read('../bacterial_16S.nex')
d = Data()

var.warnReadNoFile=False # The following reads are not file names, but that is ok.
read('(Aquifex, ((Deinococcus, Thermus), Bacillus), Thermotoga);')  # The true tree
read('(Aquifex, ((Deinococcus, Bacillus), Thermus), Thermotoga);')  # The attract tree

t = var.trees[0]  # The first tree
t.name = 'true'
t.data = d
# Define the model, with 2 compositions
cThermophiles = t.newComp(free=True, spec='empirical')
cMesophiles = t.newComp(free=True, spec='empirical')
t.newRMatrix(free=1, spec='ones')
t.setNGammaCat(nGammaCat=4)
t.newGdasrv(free=1, val=0.5)
t.setPInvar(free=0, val=0.0)
# Put the compositions on the tree appropriately.
# Make cThermophiles the default everywhere
t.setModelThing(cThermophiles, node=t.root, clade=1)
# Then over-ride it with cMesophiles on 2 branches
t.setModelThing(cMesophiles, node=t.node('Deinococcus'))
t.setModelThing(cMesophiles, node=t.node('Bacillus'))
# Check that we did it right, with a drawing
t.draw(model=True)
t.optLogLike(verbose=0)
print "The log likelihood of the '%s' tree (above) is %f\n\n" % (t.name, t.logLike)

t = var.trees[1]   # Do everything again with the second tree
t.name = 'attract'
t.data = d
cThermophiles = t.newComp(free=True, spec='empirical')
cMesophiles = t.newComp(free=True, spec='empirical')
t.newRMatrix(free=1, spec='ones')
t.setNGammaCat(nGammaCat=4)
t.newGdasrv(free=1, val=0.5)
t.setPInvar(free=0, val=0.0)
t.setModelThing(cThermophiles, node=t.root, clade=1)
t.setModelThing(cMesophiles, node=t.node('Deinococcus'))
t.setModelThing(cMesophiles, node=t.node('Bacillus'))
t.draw(model=True)
t.optLogLike(verbose=0)
print "The log likelihood of the '%s' tree (above) is %f" % (t.name, t.logLike)

