read('../bacterial_16S.nex')
d = Data()
t = func.randomTree(taxNames=d.taxNames)
t.data = d

# Define the model, with 2 compositions
c1 = t.newComp(free=1, spec='empirical')
c2 = t.newComp(free=1, spec='empirical')
t.newRMatrix(free=1, spec='ones')
t.setNGammaCat(nGammaCat=4)
t.newGdasrv(free=1, val=0.5)
t.setPInvar(free=0, val=0.0)
t.setModelThingsRandomly()

# Make an Mcmc object, and make a couple of adjustments
m = Mcmc(t, nChains=4, sampleInterval=10, checkPointInterval=None)
m.tunings.chainTemp = 0.17
m.tunings.parts[0].gdasrv = 5.0
m.tunings.parts[0].rMatrix = 10.0
m.run(10000)

# At the end, make a consensus tree from the second half of the sampled trees
tp = TreePartitions("mcmc_trees_0.nex", skip=500)
t = tp.consensus()

# Put the split support on the internal nodes so we can see it when we make a drawing
for n in t.iterInternalsNoRoot():
    n.name = int(100. * n.br.support)
t.draw()
