# We need to have all the trees that we compare to have the same
# taxNames, in the same order.  A good source for such a list would be
# the data file, bacterial_16s.nex.

read('../bacterial_16s.nex')
a = var.alignments[0]

# Now that list of taxNames is available as a.taxNames

# Now read in the 4 trees.
read('paupNJTree.nex')
read('theTrueTree.phy')
read('twoOtherTrees.nex')

# Those 4 trees are now in var.trees, a list.  We could, for example, do
#
# tA = var.trees[0]
# tB = var.trees[1]
# tA.taxNames = a.taxNames
# tB.taxNames = a.taxNames
# print tA.topologyDistance(tB)
#
# but instead we will do all of them at once.  First make a p4 Trees
# object --

tt = Trees(var.trees, taxNames=a.taxNames)

# and then ask it to do a 'topologyDistanceMatrix()'.  That method
# returns a DistanceMatrix object, which we both print to the screen
# and save to a file.

dm = tt.topologyDistanceMatrix()
dm.writeNexus()
dm.writeNexus(fName='rf_distances.nex')

# We are done the p4 tree distance calculations.  Now prepare files
# for paup and treedist.

# Now we take the 2nd tree, originally in phylip format, and write it
# out in nexus format, ready for paup.
var.trees[1].writeNexus('theTrueTree.nex')

# Finally, write the 4 trees out in phylip format to a file called
# 'intree', ready for phylip's treedist program.
tt.writeNewick()

