/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.OpenString;
import iubio.bioseq.SeqInfo;
import iubio.readseq.BioseqFormat;
import iubio.readseq.BioseqReaderIface;
import iubio.readseq.BioseqWriterIface;
import iubio.readseq.PlainSeqReader;
import iubio.readseq.PlainSeqWriter;
import iubio.readseq.VeryRawSeqReader;

public class PlainSeqFormat
extends BioseqFormat {
    protected int nnewlines;
    protected boolean reallyRaw;
    protected SeqInfo seqkind;

    public String formatName() {
        return "Plain|Raw";
    }

    public String formatSuffix() {
        return this.reallyRaw ? ".raw" : ".seq";
    }

    public String contentType() {
        return this.reallyRaw ? "biosequence/raw" : "biosequence/plain";
    }

    public BioseqWriterIface newWriter() {
        return new PlainSeqWriter();
    }

    public boolean canread() {
        return true;
    }

    public boolean canwrite() {
        return true;
    }

    public void setSeqInfoTester(SeqInfo si) {
        this.seqkind = si;
    }

    public void setVariant(String varname) {
        if ("raw".equalsIgnoreCase(varname)) {
            this.reallyRaw = true;
        }
    }

    public void formatTestInit() {
        super.formatTestInit();
        this.nnewlines = 0;
        this.reallyRaw = false;
        this.seqkind = null;
    }

    public boolean formatTestLine(OpenString line, int atline, int skiplines) {
        this.nnewlines = atline;
        return false;
    }

    public int formatTestLikelihood() {
        if (this.seqkind != null) {
            this.reallyRaw = this.seqkind.getKind() == 0 ? false : this.nnewlines < 2;
        }
        return this.formatLikelihood;
    }

    public BioseqReaderIface newReader() {
        if (this.reallyRaw) {
            return new VeryRawSeqReader();
        }
        return new PlainSeqReader();
    }
}

