/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.Environ;
import flybase.FastVector;
import flybase.Utils;
import java.awt.Font;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;

class GetUrls {
    static String title = "Open sequence URLs";
    static String message = "Enter URL(s) of sequence data, one per line";
    static String footer = "URL template (above non-URL values will insert in %% of template)";
    static String sUrlInsert = "%%";
    Object[] messagepack;
    JFrame frame;
    JTextArea jlist;
    JTextField jurltempl;

    GetUrls(JFrame frame) {
        this.frame = frame;
        this.makeUi();
    }

    FastVector getValue() {
        String txt = this.jlist.getText();
        String[] ss = Utils.splitString(txt, "\r\n, ");
        String urltempl = this.jurltempl.getText().trim();
        if (urltempl.length() > 0) {
            String tmp2;
            String tmp1;
            int at = urltempl.indexOf(sUrlInsert);
            if (at < 0) {
                tmp1 = urltempl;
                tmp2 = "";
            } else {
                tmp1 = urltempl.substring(0, at);
                tmp2 = urltempl.substring(at + sUrlInsert.length());
            }
            int i = 0;
            while (i < ss.length) {
                if (ss[i].indexOf("://") < 0) {
                    ss[i] = tmp1 + ss[i] + tmp2;
                }
                ++i;
            }
        }
        FastVector v = new FastVector(ss.length);
        int i = 0;
        while (i < ss.length) {
            try {
                v.addElement(new URL(ss[i]));
            }
            catch (Exception e) {
                // empty catch block
            }
            ++i;
        }
        return v;
    }

    public boolean choose() {
        int result = JOptionPane.showConfirmDialog(this.frame, this.messagepack, title, 2, 3);
        return result == 0;
    }

    void makeUi() {
        this.jlist = new JTextArea(7, 40);
        this.jlist.setLineWrap(false);
        this.jlist.setEditable(true);
        String urltempl = Environ.gEnv.get("SEQ_URL_TEMPLATE");
        this.jurltempl = new JTextField(urltempl, 40);
        JScrollPane sp = new JScrollPane(this.jlist);
        JLabel jfoot = new JLabel(footer, 0);
        jfoot.setFont(new Font("sanserif", 0, 10));
        jfoot.setEnabled(true);
        jfoot.setForeground(UIManager.getColor("OptionPane.messageForeground"));
        this.messagepack = new Object[]{message, sp, this.jurltempl, jfoot};
    }
}

