/*
 * Decompiled with CFR 0.152.
 */
package flybase;

import flybase.Utils;
import java.io.File;
import java.util.Random;

public class Native {
    public static final int kSysUnknown = 0;
    public static final int kSysMac = 1;
    public static final int kSysMSWin = 2;
    public static final int kSysXWin = 3;
    public static final int kSysOS2 = 4;
    public static final int kSysUntested = -1;
    public static final int mac = 1;
    public static final int mswin = 2;
    public static final int xwin = 3;
    public static final int os2 = 4;
    protected static int systemFlavor = -1;
    protected static String lineEnd = null;
    public static boolean standardLineEnd;
    private static final Object tmpFileLock;
    private static int tempnum;
    private static String tempFold;

    public static int SystemFlavor() {
        if (systemFlavor == -1) {
            String osname = System.getProperty("os.name");
            systemFlavor = (osname = osname.toLowerCase()).startsWith("mac") ? 1 : (osname.startsWith("windows") ? 2 : (osname.startsWith("os/2") ? 4 : (System.getProperty("file.separator").equals("\\") ? 2 : (System.getProperty("line.separator").equals("\n\r") ? 2 : 3))));
        }
        return systemFlavor;
    }

    public static String SystemFlavors() {
        if (systemFlavor == -1) {
            Native.SystemFlavor();
        }
        switch (systemFlavor) {
            case 1: {
                return new String("mac");
            }
            case 2: {
                return new String("mswin");
            }
            case 4: {
                return new String("os2");
            }
            case 3: {
                return new String("xwin");
            }
        }
        return new String("unknown");
    }

    public static String LineEnd() {
        if (standardLineEnd) {
            return "\n";
        }
        if (lineEnd == null) {
            lineEnd = System.getProperty("line.separator");
        }
        return lineEnd;
    }

    public static String LineEnd(int repeatCount) {
        String e = new String(Native.LineEnd());
        while (--repeatCount > 0) {
            e = e + Native.LineEnd();
        }
        return e;
    }

    public static String filePath(String javaPath) {
        String top;
        char cto;
        if (javaPath == null) {
            return null;
        }
        char cfrom = File.separatorChar;
        if (systemFlavor == -1) {
            Native.SystemFlavor();
        }
        switch (systemFlavor) {
            case 1: {
                cto = ':';
                top = "";
                break;
            }
            case 2: 
            case 4: {
                cto = '\\';
                top = "\\";
                break;
            }
            default: {
                cto = '/';
                top = "/";
            }
        }
        boolean changetop = javaPath.charAt(0) == cfrom;
        String twoSlash = File.separator + File.separator;
        int at = javaPath.indexOf(twoSlash);
        while (at >= 0) {
            javaPath = javaPath.substring(0, at) + javaPath.substring(at + 1);
            at = javaPath.indexOf(twoSlash);
        }
        String nativePath = javaPath.replace(cfrom, cto);
        nativePath = Utils.decode(nativePath);
        if (changetop) {
            nativePath = top + nativePath.substring(1);
        }
        return nativePath;
    }

    public static String tempFolder() {
        if (tempFold == null) {
            String fold = null;
            File ff = null;
            if (systemFlavor == -1) {
                Native.SystemFlavor();
            }
            switch (systemFlavor) {
                case 1: {
                    break;
                }
                case 3: {
                    ff = new File("/tmp", "");
                    break;
                }
                case 2: 
                case 4: {
                    ff = new File("\\tmp", "");
                    if (ff == null || !ff.exists()) {
                        ff = new File("\\temp", "");
                    }
                    if (ff != null && ff.exists()) break;
                    ff = new File("c:\\temp", "");
                }
            }
            if (ff != null && ff.exists() && ff.isDirectory()) {
                fold = ff.getPath();
            }
            if (fold == null || fold.length() == 0) {
                fold = System.getProperty("user.dir", "") + "/";
            }
            tempFold = fold;
        }
        return tempFold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String tempFilename(String prefix, String suffix) {
        if (prefix == null) {
            prefix = "dclap";
        }
        if (suffix == null) {
            suffix = ".tmp";
        }
        Object object = tmpFileLock;
        synchronized (object) {
            if (tempnum == -1) {
                tempnum = new Random().nextInt() & 0xFFFF;
            }
            prefix = prefix + Integer.toString(++tempnum) + suffix;
        }
        return prefix;
    }

    public static final String tempFilename(String suffix) {
        return Native.tempFilename("dclap", suffix);
    }

    public static final File tempFile() {
        return Native.tempFile(".tmp");
    }

    public static File tempFile(String suffix) {
        String tfold = Native.tempFolder();
        if (tfold == null || tfold.length() == 0) {
            return new File(Native.tempFilename(suffix));
        }
        return new File(tfold, Native.tempFilename(suffix));
    }

    static {
        Native.SystemFlavor();
        standardLineEnd = false;
        tmpFileLock = new Object();
        tempnum = -1;
        tempFold = null;
    }
}

