/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.parsers;

import com.ibm.xml.framework.StringPool;
import com.ibm.xml.framework.XMLParser;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;

public class SAXParser
extends XMLParser {
    private DTDHandler fDTDHandler = null;
    private DocumentHandler fDocumentHandler = null;

    public SAXParser() {
        this.getParserState().useDefaultStringPool();
        this.getParserState().useDefaultAttrPool();
        this.getParserState().useDefaultEntityPool();
        this.getParserState().useDefaultElementDeclPool();
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.getEntityHandler().setEntityResolver(resolver);
    }

    public void setDTDHandler(DTDHandler handler) {
        this.fDTDHandler = handler;
        this.setDocumentTypeHandler(handler == null ? null : this);
    }

    public void setDocumentHandler(DocumentHandler handler) {
        this.fDocumentHandler = handler;
        this.setDocumentHandler(handler == null ? null : this);
    }

    public void doctypeDecl(int rootElementNameIndex) throws Exception {
    }

    public void startInternalSubset() throws Exception {
    }

    public void endInternalSubset() throws Exception {
    }

    public void startExternalSubset(int publicIdStringIndex, int systemIdStringIndex) throws Exception {
    }

    public void endExternalSubset() throws Exception {
    }

    public void elementDecl(int elementIndex) throws Exception {
    }

    public void attlistDecl(int elementIndex, int attDefIndex) throws Exception {
    }

    public void internalEntityDecl(int entityIndex) throws Exception {
    }

    public void externalEntityDecl(int entityIndex) throws Exception {
    }

    public void unparsedEntityDecl(int entityIndex) throws Exception {
        String name = this.getParserState().getStringPool().toString(this.getParserState().getEntityPool().getEntityName(entityIndex));
        String publicId = this.getParserState().getStringPool().toString(this.getParserState().getEntityPool().getPublicId(entityIndex));
        String systemId = this.getParserState().getStringPool().toString(this.getParserState().getEntityPool().getSystemId(entityIndex));
        String notation = this.getParserState().getStringPool().toString(this.getParserState().getEntityPool().getNotationName(entityIndex));
        this.fDTDHandler.unparsedEntityDecl(name, publicId, systemId, notation);
    }

    public void notationDecl(int notationIndex) throws Exception {
        String name = this.getParserState().getStringPool().toString(this.getParserState().getEntityPool().getNotationName(notationIndex));
        String publicId = this.getParserState().getStringPool().toString(this.getParserState().getEntityPool().getPublicId(notationIndex));
        String systemId = this.getParserState().getStringPool().toString(this.getParserState().getEntityPool().getSystemId(notationIndex));
        this.fDTDHandler.notationDecl(name, publicId, systemId);
    }

    public boolean sendCharDataAsCharArray() {
        return true;
    }

    public void startDocument(int versionIndex, int encodingIndex, int standAloneIndex) throws Exception {
        StringPool strPool = this.getParserState().getStringPool();
        strPool.orphanString(versionIndex);
        strPool.orphanString(encodingIndex);
        strPool.orphanString(standAloneIndex);
        this.fDocumentHandler.setDocumentLocator(this.getLocator());
        this.fDocumentHandler.startDocument();
    }

    public void endDocument() throws Exception {
        this.fDocumentHandler.endDocument();
    }

    public void startElement(int elementNameIndex, int attrListIndex) throws Exception {
        this.fDocumentHandler.startElement(this.getParserState().getStringPool().toString(elementNameIndex), this.getParserState().getAttrPool().getAttributeList(attrListIndex));
        this.getParserState().getAttrPool().releaseAttrList(attrListIndex);
    }

    public void endElement(int elementNameIndex) throws Exception {
        this.fDocumentHandler.endElement(this.getParserState().getStringPool().toString(elementNameIndex));
    }

    public void startEntityReference(int entityIndex) throws Exception {
    }

    public void endEntityReference(int entityIndex) throws Exception {
    }

    public void characters(int dataIndex, boolean cdataSection) throws Exception {
        String s = this.getParserState().getStringPool().orphanString(dataIndex);
        this.fDocumentHandler.characters(s.toCharArray(), 0, s.length());
    }

    public void ignorableWhitespace(int dataIndex, boolean cdataSection) throws Exception {
        String s = this.getParserState().getStringPool().orphanString(dataIndex);
        this.fDocumentHandler.ignorableWhitespace(s.toCharArray(), 0, s.length());
    }

    public void processingInstruction(int targetIndex, int dataIndex) throws Exception {
        this.fDocumentHandler.processingInstruction(this.getParserState().getStringPool().orphanString(targetIndex), this.getParserState().getStringPool().orphanString(dataIndex));
    }

    public void comment(int dataIndex) throws Exception {
        this.getParserState().getStringPool().releaseString(dataIndex);
    }

    public void characters(char[] ch, int start, int length, boolean cdataSection) throws Exception {
        this.fDocumentHandler.characters(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length, boolean cdataSection) throws Exception {
        this.fDocumentHandler.ignorableWhitespace(ch, start, length);
    }
}

