/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import Acme.Fmt;
import iubio.bioseq.SeqInfo;
import iubio.readseq.InterleavedSeqWriter;
import iubio.readseq.PaupOutBase;
import java.io.IOException;
import java.io.RandomAccessFile;

class PaupSeqWriter
extends InterleavedSeqWriter {
    PaupSeqWriter() {
    }

    protected void interleaf(int leaf) {
        if (leaf == 0) {
            this.writeln();
            this.writeln("MATRIX");
        } else {
            this.writeln();
        }
    }

    protected void interleaveHeader() {
        String skind = SeqInfo.getKindLabel(this.bioseq.getSeqtype());
        this.writeln("#NEXUS");
        this.writeln();
        this.writeln();
        this.writeln("BEGIN DATA;");
        this.writeString(" DIMENSIONS NTAX=" + Integer.toString(this.getNseq()));
        this.writeln(" NCHAR=" + this.seqLen() + ";");
        this.writeString(" FORMAT DATATYPE=" + skind);
        this.writeString(" INTERLEAVE MISSING=" + this.opts.gapchar);
        if (this.opts.domatch) {
            this.writeString(" MATCHCHAR=" + this.opts.matchchar);
        }
        this.writeln(";");
    }

    public void writeTrailer() {
        super.writeTrailer();
        this.writeln(";");
        this.writeln("END;");
        try {
            this.douts.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeRecordStart() {
        super.writeRecordStart();
        this.setOutputTranslation(new PaupOutBase(this.getOutputTranslation()));
        this.opts.nameleft = true;
        this.opts.nameflags = 2;
        this.opts.namewidth = 20;
        this.opts.seqwidth = 100;
        this.opts.spacer = 20;
        this.opts.tab = 0;
    }

    public void writeDoc() {
        super.writeDoc();
        this.writeString("[Name: " + Fmt.fmt(this.idword, 16, 2));
        this.writeString(" Len:" + Fmt.fmt(this.seqlen, 6));
        this.writeString("  Check:" + Fmt.fmt(this.checksum, 5));
        this.writeln("]");
    }

    protected void writePadLine(RandomAccessFile tempis, int iseq, long starti) {
        try {
            int idoc;
            tempis.seek(starti);
            String line = tempis.readLine();
            int n = idoc = line == null ? -1 : line.indexOf("[Name: ");
            if (idoc >= 0) {
                int edoc = line.indexOf(" ", idoc += 7);
                String idword = line.substring(idoc, edoc).trim();
                this.writeString(Fmt.fmt(idword, this.opts.namewidth, this.opts.nameflags));
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }
}

