/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import Acme.Fmt;
import flybase.FastHashtable;
import flybase.SortedEnumeration;
import iubio.readseq.BasicBioseqDoc;
import iubio.readseq.BioseqDoc;
import iubio.readseq.BioseqRecord;
import iubio.readseq.BioseqWriter;
import iubio.readseq.Readseq;
import iubio.readseq.SeqFileInfo;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;

public class CompareSeqWriter
extends BioseqWriter {
    int seqkind;
    int ndiff;
    long mycrc;
    long osicrc;
    BioseqRecord mysi;
    BioseqRecord osi;
    String myname = "myname";
    String oldname = "oldname";
    String flags = "";
    boolean haslibs;
    FastHashtable libs;
    final boolean bClearRec = true;

    public void setFlags(String flags) {
        if (flags == null) {
            flags = "";
        }
        this.flags = flags;
    }

    public void setSourceNames(String myname, String oldname) {
        this.myname = myname;
        this.oldname = oldname;
    }

    final String namefmt(String name) {
        return Fmt.fmt(name, 8, 2);
    }

    public void writeHeader() throws IOException {
        super.writeHeader();
        this.diffLibHeader();
        this.diffSummaryHeader();
    }

    public void diffLibHeader() {
        this.writeln("# Compare sequences with " + Readseq.version);
        this.writeln("# Compare options: keyid,keycrc,keytitle,keyindex ; nosame,nosummary,noid,notitle,nolength,nocrc,nodoc]");
        this.writeln("# Compare optval : " + this.flags);
        this.writeln("# Compare sources: " + this.namefmt(this.myname) + " --- " + this.namefmt(this.oldname));
    }

    void diffSummaryHeader() {
        if (this.flags.indexOf("nosum") < 0) {
            this.writeString(Fmt.fmt("  ", 8, 2) + " ");
            this.writeString(Fmt.fmt("ID", 15, 2) + " ");
            this.writeString(Fmt.fmt("Length", 15) + " ");
            this.writeString(Fmt.fmt("Checksum", 15));
            this.writeln();
        }
    }

    protected FastHashtable getLib(String name) {
        if (this.libs == null) {
            this.libs = new FastHashtable();
        }
        this.haslibs = true;
        FastHashtable alib = (FastHashtable)this.libs.get(name);
        if (alib == null) {
            alib = new FastHashtable();
            this.libs.put(name, alib);
        }
        return alib;
    }

    public void addLib(String name, BioseqRecord rec) {
        if (name == null || rec == null) {
            return;
        }
        String rid = rec.getID();
        long crc = rec.getChecksum();
        String title = rec.getTitle();
        FastHashtable lib = this.getLib(name);
        boolean didcrc = false;
        if (this.flags.indexOf("keyid") < 0) {
            if (this.flags.indexOf("keytit") >= 0) {
                rid = title;
            } else if (this.flags.indexOf("keyindex") >= 0) {
                rid = String.valueOf(lib.size());
            } else if (this.flags.indexOf("keycrc") >= 0) {
                rid = String.valueOf(crc);
                didcrc = true;
            }
        }
        if (lib.containsKey(rid)) {
            rid = rid + String.valueOf(lib.size());
        }
        lib.put(rid, rec);
        if (!didcrc) {
            lib = this.getLib(name + ".crc");
            if (lib.containsKey(rid = String.valueOf(crc))) {
                rid = rid + String.valueOf(lib.size());
            }
            lib.put(rid, rec);
        }
        if (this.flags.indexOf("nodoc") >= 0) {
            rec.clear();
        }
    }

    public void compareLibs(String aname, String bname) throws IOException {
        BioseqRecord ar;
        String aid;
        FastHashtable alib = this.getLib(aname);
        FastHashtable blib = this.getLib(bname);
        FastHashtable blibcrc = this.getLib(bname + ".crc");
        this.setSourceNames(aname, bname);
        int libdiff = 0;
        super.writeHeader();
        this.diffLibHeader();
        this.ndiff = 0;
        if (alib.size() != blib.size()) {
            this.diff("Library size", String.valueOf(alib.size()), String.valueOf(blib.size()));
        }
        libdiff += this.ndiff;
        this.ndiff = 0;
        this.diffSummaryHeader();
        StringWriter sw = new StringWriter();
        Writer saveouts = this.douts;
        this.douts = sw;
        FastHashtable adid = new FastHashtable();
        FastHashtable bdid = new FastHashtable();
        Enumeration an = new SortedEnumeration(alib.keys()).elements();
        while (an.hasMoreElements()) {
            String acrc;
            aid = (String)an.nextElement();
            ar = (BioseqRecord)alib.get(aid);
            BioseqRecord br = (BioseqRecord)blib.get(aid);
            if (br == null && !adid.containsKey(acrc = String.valueOf(ar.getChecksum()))) {
                br = (BioseqRecord)blibcrc.get(acrc);
            }
            if (br == null) continue;
            bdid.put(aid, aid);
            acrc = String.valueOf(ar.getChecksum());
            adid.put(acrc, acrc);
            this.showDiff(ar, br);
            this.showSeqDiff(ar, br);
            this.showDocDiff(ar, br);
            if (this.flags.indexOf("nosum") < 0) {
                this.writeln("# No. record differences: " + this.ndiff);
            }
            if (this.ndiff > 0 || this.flags.indexOf("nosame") < 0) {
                saveouts.write(sw.toString());
            }
            if (this.ndiff > 0) {
                ++libdiff;
                this.ndiff = 0;
            }
            sw.getBuffer().setLength(0);
        }
        an = new SortedEnumeration(alib.keys()).elements();
        while (an.hasMoreElements()) {
            aid = (String)an.nextElement();
            if (bdid.containsKey(aid)) continue;
            ar = (BioseqRecord)alib.get(aid);
            this.showDiff(ar, null);
            if (this.flags.indexOf("nosum") < 0) {
                this.writeln("# No. record differences: " + this.ndiff);
            }
            if (this.ndiff > 0 || this.flags.indexOf("nosame") < 0) {
                saveouts.write(sw.toString());
            }
            if (this.ndiff > 0) {
                ++libdiff;
                this.ndiff = 0;
            }
            sw.getBuffer().setLength(0);
        }
        an = new SortedEnumeration(blib.keys()).elements();
        while (an.hasMoreElements()) {
            aid = (String)an.nextElement();
            if (bdid.containsKey(aid)) continue;
            BioseqRecord br = (BioseqRecord)blib.get(aid);
            this.showDiff(null, br);
            if (this.flags.indexOf("nosum") < 0) {
                this.writeln("# No. record differences: " + this.ndiff);
            }
            if (this.ndiff > 0 || this.flags.indexOf("nosame") < 0) {
                saveouts.write(sw.toString());
            }
            if (this.ndiff > 0) {
                ++libdiff;
                this.ndiff = 0;
            }
            sw.getBuffer().setLength(0);
        }
        this.douts = saveouts;
        this.writeln();
        this.writeln("# No. library differences: " + libdiff);
    }

    public void writeRecordStart() {
        super.writeRecordStart();
        this.showDiff(this.mysi, this.osi);
    }

    public boolean setSeq(SeqFileInfo si) {
        this.mysi = si instanceof BioseqRecord ? (BioseqRecord)si : new BioseqRecord(si);
        return this.mysi != null;
    }

    public void compareTo(BioseqRecord oldsi) {
        this.osi = oldsi;
    }

    protected void diff(String fld, String newval, String oldval) {
        this.writeString(Fmt.fmt(fld, 15, 2) + ": ");
        this.writeString(Fmt.fmt(newval, 15));
        this.writeString(" != ");
        this.writeString(Fmt.fmt(oldval, 15));
        this.writeln();
        ++this.ndiff;
    }

    public void showDiff(BioseqRecord mysi, BioseqRecord osi) {
        this.mycrc = mysi == null ? 0L : mysi.getChecksum();
        long l = this.osicrc = osi == null ? 0L : osi.getChecksum();
        if (this.flags.indexOf("nosum") < 0) {
            if (mysi == null) {
                this.writeString("null");
            } else {
                this.writeString(this.namefmt(this.myname) + " ");
                this.writeString(Fmt.fmt(mysi.getID(), 15, 2) + " ");
                this.writeString(Fmt.fmt(mysi.length(), 15) + " ");
                this.writeString(Fmt.fmt(Long.toHexString(this.mycrc).toUpperCase(), 15));
            }
            this.writeln();
            if (osi == null) {
                this.writeString("null");
            } else {
                this.writeString(this.namefmt(this.oldname) + " ");
                this.writeString(Fmt.fmt(osi.getID(), 15, 2) + " ");
                this.writeString(Fmt.fmt(osi.length(), 15) + " ");
                this.writeString(Fmt.fmt(Long.toHexString(this.osicrc).toUpperCase(), 15));
            }
            this.writeln();
        } else {
            if (mysi == null) {
                this.writeString("null");
            } else {
                this.writeString(this.namefmt(this.myname) + ":" + Fmt.fmt(mysi.getID(), 15, 2));
            }
            this.writeString(" -- ");
            if (osi == null) {
                this.writeString("null");
            } else {
                this.writeString(this.namefmt(this.oldname) + ":" + Fmt.fmt(osi.getID(), 15, 2));
            }
            this.writeln();
        }
        this.ndiff = 0;
        if (mysi == null && osi != null) {
            ++this.ndiff;
        } else if (mysi != null && osi == null) {
            ++this.ndiff;
        }
    }

    public void writeRecordEnd() {
        this.writeln("# No. record differences: " + this.ndiff);
        this.writeln();
    }

    public void writeSeq() {
        this.showSeqDiff(this.mysi, this.osi);
    }

    protected void showSeqDiff(BioseqRecord mysi, BioseqRecord osi) {
        if (mysi == null || osi == null) {
            return;
        }
        if (this.flags.indexOf("nolen") < 0 && mysi.length() != osi.length()) {
            this.diff("Sequence length", String.valueOf(mysi.length()), String.valueOf(osi.length()));
        } else if (this.flags.indexOf("nocrc") < 0 && this.mycrc != this.osicrc) {
            this.diff("Sequence checksum", Long.toHexString(this.mycrc).toUpperCase(), Long.toHexString(this.osicrc).toUpperCase());
        }
    }

    public void writeDoc() {
        this.showDocDiff(this.mysi, this.osi);
    }

    protected void showDocDiff(BioseqRecord mysi, BioseqRecord osi) {
        if (mysi == null || osi == null) {
            return;
        }
        if (this.flags.indexOf("noid") < 0 && !mysi.getID().equals(osi.getID())) {
            this.diff("ID", mysi.getID(), osi.getID());
        }
        if (this.flags.indexOf("notitle") < 0 && !mysi.getTitle().equals(osi.getTitle())) {
            this.diff("Title", mysi.getTitle(), osi.getTitle());
        }
        if (mysi.getdoc() instanceof BioseqDoc) {
            BasicBioseqDoc doc = new BasicBioseqDoc(mysi.getdoc());
            BasicBioseqDoc olddoc = new BasicBioseqDoc(osi.getdoc());
            if (this.flags.indexOf("nodoc") < 0) {
                this.ndiff += doc.compareTo(this.douts, olddoc);
            }
        }
    }
}

