/*
 * Decompiled with CFR 0.152.
 */
package flybase;

import flybase.FastProperties;
import flybase.Utils;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class Environ {
    public static String envPropertiesName = "Environ";
    public static Environ gEnv;
    public static String gVarkey;
    protected FastProperties syms = new FastProperties();

    public Environ() {
    }

    public Environ(String propertiesName) {
        this.syms.loadProperties(propertiesName);
    }

    protected Environ(boolean forstatic) {
        String ename = System.getProperty("app.environ", envPropertiesName);
        try {
            this.syms.loadProperties(ename);
        }
        catch (Exception e) {}
    }

    public void getResource(String propertiesName) {
        this.syms.loadProperties(propertiesName);
    }

    public boolean isdefined(String hsymbol) {
        if (hsymbol == null) {
            return false;
        }
        return this.syms.getProperty(hsymbol) != null;
    }

    public void save(OutputStream out, String header) {
        this.syms.save(out, header);
    }

    public void print(PrintStream aout) {
        this.syms.list(aout);
    }

    public final FastProperties gethash() {
        return this.syms;
    }

    public final String getsym(String hsymbol) {
        return this.syms.getProperty(hsymbol);
    }

    public String get(String hsymbol, String defaultvalue) {
        String val = this.get(hsymbol);
        if (val == null || val.length() == 0) {
            if (defaultvalue == null) {
                defaultvalue = "";
            }
            val = defaultvalue;
            this.set(hsymbol, val);
        }
        return val;
    }

    public String get(String hsymbol) {
        if (hsymbol == null) {
            return "";
        }
        String val = this.syms.getProperty(hsymbol);
        if (val != null) {
            int at = val.indexOf(gVarkey);
            while (at >= 0) {
                int e = val.indexOf(gVarkey, at + 2);
                if (e > at) {
                    String sym2 = val.substring(at + 2, e);
                    String val2 = this.get(sym2);
                    val = val.substring(0, at) + val2 + val.substring(e + 2);
                    at = val.indexOf(gVarkey, at);
                    continue;
                }
                at = -1;
            }
            return val;
        }
        return "";
    }

    public String[] getList(String hsymbol) {
        String val = this.get(hsymbol);
        return Utils.splitString(val);
    }

    public String[] getList(String hsymbol, String defvalue, String delims) {
        String val = this.get(hsymbol, defvalue);
        return Utils.splitString(val, delims);
    }

    public final int getInt(String hsymbol) {
        return this.getInt(hsymbol, 0);
    }

    public int getInt(String hsymbol, int defaultvalue) {
        try {
            return Integer.parseInt(this.get(hsymbol, String.valueOf(defaultvalue)));
        }
        catch (Exception e) {
            return 0;
        }
    }

    public final boolean getBoolean(String hsymbol) {
        return this.isTrue(hsymbol);
    }

    public final boolean isTrue(String hsymbol) {
        String val = this.get(hsymbol);
        return "true".equalsIgnoreCase(val) || "1".equals(val) || "on".equalsIgnoreCase(val);
    }

    public final boolean isTrue(String hsymbol, boolean defaultvalue) {
        String val = this.get(hsymbol, String.valueOf(defaultvalue));
        return "true".equalsIgnoreCase(val) || "1".equals(val) || "on".equalsIgnoreCase(val);
    }

    public void set(String hsymbol, String value) {
        this.syms.put(hsymbol, value);
    }

    public void set(String hsymbol, boolean value) {
        this.syms.put(hsymbol, String.valueOf(value));
    }

    public void set(String hsymbol, int value) {
        this.syms.put(hsymbol, String.valueOf(value));
    }

    public void set(String hsymbol, double value) {
        this.syms.put(hsymbol, String.valueOf(value));
    }

    public void set(String hsymbol, Object value) {
        this.syms.put(hsymbol, String.valueOf(value));
    }

    public String append(String hsymbol, String value) {
        String val = (String)this.syms.get(hsymbol);
        val = val == null ? value : val + "\t" + value;
        this.set(hsymbol, val);
        return val;
    }

    public void readProperties(String propertiesFile) {
        try {
            BufferedInputStream ins = new BufferedInputStream(new FileInputStream(propertiesFile));
            this.syms.load(ins);
        }
        catch (Exception e) {
            System.err.println("Error loading " + propertiesFile + ": " + e.getMessage());
        }
    }

    static {
        gVarkey = "%%";
        gEnv = new Environ(true);
    }
}

