/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.internal;

import com.ibm.xml.framework.ChunkyByteArray;
import com.ibm.xml.framework.ParserState;
import com.ibm.xml.framework.StringPool;
import com.ibm.xml.framework.XMLDeclRecognizer;
import com.ibm.xml.framework.XMLEntityHandler;
import com.ibm.xml.framework.XMLReader;
import com.ibm.xml.internal.CharReader;
import com.ibm.xml.internal.EBCDICRecognizer;
import com.ibm.xml.internal.UCSRecognizer;
import com.ibm.xml.internal.UTF8CharReader;
import com.ibm.xml.internal.UTF8Reader;
import com.ibm.xml.internal.UTF8Recognizer;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Stack;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public final class DefaultEntityHandler
implements XMLEntityHandler {
    private static final boolean DEBUG = false;
    private Stack fRecognizers = null;
    private Stack fInputSourceStack = null;
    private ParserState fParserState = null;
    private EntityResolver fResolver = null;

    public DefaultEntityHandler(ParserState parserState) {
        this.fParserState = parserState;
        this.fInputSourceStack = new Stack();
        this.initializeRecognizers();
    }

    public void reset(ParserState parserState) {
        this.fParserState = parserState;
        this.fInputSourceStack.removeAllElements();
    }

    public void addRecognizer(XMLDeclRecognizer recognizer) {
        this.fRecognizers.push(recognizer);
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.fResolver = resolver;
    }

    public EntityResolver getEntityResolver() {
        return this.fResolver;
    }

    public InputSource resolveEntity(int publicId, int systemId) throws Exception {
        EntityResolver resolver = this.fResolver;
        if (resolver != null) {
            StringPool pool = this.fParserState.getStringPool();
            String publicIdStr = pool.toString(publicId);
            String systemIdStr = pool.toString(systemId);
            return resolver.resolveEntity(publicIdStr, systemIdStr);
        }
        return null;
    }

    public int expandSystemId(int systemId) {
        if (systemId != -1) {
            ParserState state = this.fParserState;
            StringPool string = state.getStringPool();
            try {
                String systemLiteral = string.toString(systemId);
                URL url = this.expandSystemId(systemLiteral);
                if (url != null) {
                    return string.addString(url.toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return systemId;
    }

    public XMLReader createReader(InputSource source, boolean xmlDecl) throws Exception {
        ChunkyByteArray data;
        XMLReader reader;
        if (source.getCharacterStream() != null) {
            return new CharReader(this.fParserState, source.getPublicId(), source.getSystemId(), source.getCharacterStream());
        }
        if (source.getEncoding() != null && source.getByteStream() != null) {
            return new CharReader(this.fParserState, source.getPublicId(), source.getSystemId(), new InputStreamReader(source.getByteStream(), source.getEncoding()));
        }
        InputStream is = source.getByteStream();
        if (is == null) {
            String id = source.getSystemId();
            if (id != null) {
                try {
                    ParserState state = this.fParserState;
                    StringPool string = state.getStringPool();
                    int oldindex = string.addString(id);
                    int newindex = state.getEntityHandler().expandSystemId(oldindex);
                    if (oldindex != newindex) {
                        id = string.orphanString(newindex);
                        source.setSystemId(id);
                    }
                    string.releaseString(oldindex);
                }
                catch (Exception exception) {}
            }
            URL url = new URL(id);
            is = url.openStream();
        }
        if ((reader = this.callRecognizers(source, xmlDecl, data = new ChunkyByteArray(is))) == null) {
            ParserState parserState = this.fParserState;
            reader = true ? new UTF8CharReader(this.fParserState, source.getPublicId(), source.getSystemId(), data) : new UTF8Reader(this.fParserState, source.getPublicId(), source.getSystemId(), data);
        }
        return reader;
    }

    public void startInputSource(InputSource inputSource) {
        this.fInputSourceStack.push(inputSource);
    }

    public void endInputSource(InputSource inputSource) {
        InputSource lastSource = (InputSource)this.fInputSourceStack.pop();
        if (lastSource != inputSource) {
            try {
                this.fParserState.getErrorHandler().error(170);
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    public URL expandSystemId(String systemId) throws Exception {
        String currentSystemId;
        if (systemId == null) {
            systemId = "/";
        }
        try {
            URL url = new URL(systemId);
            if (url != null) {
                return null;
            }
        }
        catch (MalformedURLException malformedURLException) {}
        systemId = DefaultEntityHandler.fixURI(systemId);
        try {
            InputSource currentSource = (InputSource)this.fInputSourceStack.peek();
            currentSystemId = currentSource.getSystemId();
        }
        catch (Exception exception) {
            currentSystemId = null;
        }
        URL base = null;
        if (currentSystemId == null) {
            String dir;
            try {
                dir = DefaultEntityHandler.fixURI(System.getProperty("user.dir"));
            }
            catch (SecurityException securityException) {
                dir = "";
            }
            if (!dir.endsWith("/")) {
                dir = String.valueOf(dir) + "/";
            }
            base = new URL("file", "", dir);
        } else {
            base = new URL(currentSystemId);
        }
        return new URL(base, systemId);
    }

    private void initializeRecognizers() {
        if (this.fRecognizers == null) {
            this.fRecognizers = new Stack();
            this.fRecognizers.push(new EBCDICRecognizer());
            this.fRecognizers.push(new UCSRecognizer());
            this.fRecognizers.push(new UTF8Recognizer());
        }
    }

    private XMLReader callRecognizers(InputSource source, boolean xmlDecl, ChunkyByteArray data) throws Exception {
        int i = this.fRecognizers.size() - 1;
        while (i >= 0) {
            XMLDeclRecognizer recognizer = (XMLDeclRecognizer)this.fRecognizers.elementAt(i);
            XMLReader reader = recognizer.recognize(this.fParserState, source, data, xmlDecl);
            if (reader != null) {
                return reader;
            }
            --i;
        }
        return null;
    }

    private static String fixURI(String str) {
        char ch0;
        char ch1;
        if ((str = str.replace(File.separatorChar, '/')).length() >= 2 && (ch1 = str.charAt(1)) == ':' && (ch0 = Character.toUpperCase(str.charAt(0))) >= 'A' && ch0 <= 'Z') {
            str = "/" + str;
        }
        return str;
    }
}

