//  Alexander Griekspoor (mek@mekentosj.com)
//  Charles Parnot (charles.parnot@stanford.edu)
//  mekentosj.com - Sat Jan 08 2005



// used for debugging
function debug(msg) {
	if (!debug.box) {
		debug.box = document.createElement("div");
		debug.box.setAttribute("style", "background-color: white; " +
										"font-family: monospace; " +
										"border: solid black 3px; " +
										"position: absolute;top:300px;" +
										"padding: 10px;");
		document.body.appendChild(debug.box);
		debug.box.innerHTML = "<h1 style='text-align:center'>debug Output</h1>";
	}
	
	var p = document.createElement("p");
	p.appendChild(document.createTextNode(msg));
	debug.box.appendChild(p);
}

// used to open urls from widget
function clickedLink(url){ 
	if (window.widget) 
		widget.openURL(url);

	// switch the widget back to the front
	setTimeout('hidePrefs()',1000);
}


//manipulating rectangles

//given a rectangle rotated with angle beta around the origin, returns the straight rectangle (angle 0) that will enclose it, with integer coordinates
//beta has to be between 0 and 2PI
function straight_rectangle(old,beta)
{
		//intermediate values
		var cos = Math.cos (beta);
		var sin = Math.sin (beta);
		
		//make 4 cases for the 4 quadrants
		var quad = beta / Math.PI;
		var final_rect;
		//debug ("quad:"+quad);
		if ( quad < 0.5 )
			final_rect = {
				x: cos * old.x - sin * ( old.y + old.h ),
				y: sin * old.x + cos * old.y,
				w: + cos * old.w + sin * old.h,
				h: + cos * old.h + sin * old.w
			};
		else if ( quad < 1.0 )
			final_rect = {
				x: cos * ( old.x + old.w ) - sin * ( old.y + old.h ),
				y: sin * old.x + cos * ( old.y + old.h ),
				w: - cos * old.w + sin * old.h,
				h: - cos * old.h + sin * old.w
			};
		else if ( quad < 1.5 )
			final_rect = {
				x: cos * ( old.x + old.w ) - sin * old.y,
				y: sin * ( old.x + old.w ) + cos * ( old.y + old.h ),
				w: - cos * old.w - sin * old.h,
				h: - cos * old.h - sin * old.w
			};
		else 
			final_rect = {
				x: cos * old.x - sin * old.y,
				y: sin * (old.x + old.w) + cos * old.y,
				w: + cos * old.w - sin * old.h,
				h: + cos * old.h - sin * old.w
			};
	
	//return rect with integer coordinates
	return {
		x:Math.floor(final_rect.x),
		y:Math.floor(final_rect.y),
		w:Math.ceil (final_rect.w),
		h:Math.ceil (final_rect.h)
	};
}


function intersection ( rect1, rect2 )
{
	//simple cases where there is no intersection possible
	if ( rect1.x > rect2.x + rect2.w )
		return {x:0,y:0,w:0,h:0};
	if ( rect2.x > rect1.x + rect1.w )
		return {x:0,y:0,w:0,h:0};
	if ( rect1.y > rect2.y + rect2.h )
		return {x:0,y:0,w:0,h:0};
	if ( rect2.y > rect1.y + rect1.h )
		return {x:0,y:0,w:0,h:0};
	
	//there is an intersection
	var xnew = Math.max (rect1.x,rect2.x);
	var wnew = Math.min(rect1.x+rect1.w,rect2.x+rect2.w)-xnew;
	var ynew = Math.max (rect1.y,rect2.y);
	var hnew = Math.min(rect1.y+rect1.h,rect2.y+rect2.h)-ynew;
	return { x:xnew,y:ynew,w:wnew,h:hnew };
}

function union ( rect1, rect2 )
{
	if ( rect1.w == 0 && rect1.h == 0 )
		return { x:rect2.x, y:rect2.y, w:rect2.w, h:rect2.h };
	if ( rect2.w == 0 && rect2.h == 0 )
		return { x:rect1.x, y:rect1.y, w:rect1.w, h:rec1.h };
	var xnew = Math.min(rect1.x,rect2.x);
	var ynew = Math.min(rect1.y,rect2.y);
	var wnew = Math.max(rect1.x+rect1.w,rect2.x+rect2.w) - xnew;
	var hnew = Math.max(rect1.y+rect1.h,rect2.y+rect2.h) - ynew;
	return { x:xnew, y:ynew, w:wnew, h:hnew };
}

function string_from_rect (rect)
{
	return "x:"+rect.x+", y:"+rect.y+", w:"+rect.w+", h:"+rect.h;
}

