// =======================================
// PULSE OBJECT
// =======================================

/*
the pulse object is used for animations

it is modeled as a point moving counter clockwise around a circle:
	- its imaginary position is defined by its angular position in the circle
	- the x position is the projection on the horizontal axis
	- its period determines the speed of rotation

USAGE
	//frequency, position, target --> amplitude = abs (target-position)
	cool_pulse = new Pulse ( 1 , 50, 100); 
	cool_pulse.move(0.1);
	newposition = cool_pulse.position;
	//change the beating to be faster = twice a second
	cool_pulse.setFrequency(2);
*/

var max_angle = 2 * Math.PI;

//constructor
function Pulse ( frequency, position, target ) {

	this.target = target;
	this.radius = Math.abs ( position - target );
	this.frequency = frequency;

	this.position = position;
	if ( this.position > this.target )
		this.angle = 0;
	else
		this.angle = max_angle / 2;
	
	//methods
	this.setFrequency = setFrequency;
	this.move = move_pulse;
	
}

function setFrequency ( new_frequency ) {
	this.frequency = new_frequency
}

//move to time t + dt
function move_pulse ( dt ) {
	this.angle += 2 * max_angle * this.frequency * dt;
	if ( this.angle > max_angle )
		this.angle -= max_angle;
	this.position = this.target + this.radius * Math.cos ( this.angle );
}
