//  Alexander Griekspoor (mek@mekentosj.com)
//  Charles Parnot (charles.parnot@stanford.edu)
//  mekentosj.com - Sat Jan 08 2005


// =======================================
// SKINS
// =======================================

/*
Skin objects should respond to the following messages

sync()  :  assume all of the widget parameters have changed and get ready to redraw everything on the next frame

start() : start animation if not already running

stop()  : pause animation

click() : please, skin, respond to click in the widget

*/

var skinClasses = { classic:'Skin2' , symmetric:'Skin1', glowing:'Skin4', noanimation:'Skin5' };
var skinObjects = { classic:null , symmetric:null, glowing:null, noanimation:null };
var skinPopupIndex = { classic:0, symmetric:1, glowing:2, noanimation:3 };
var skinPopupDisplay = { classic:'Classic', symmetric:'Symmetric', glowing:'Glowing', noanimation:'Static' };

var skin;

function setSkin ( skinName )
{
	if ( skinObjects[skinName] == null )
		eval ( 'skinObjects[skinName] = new ' + skinClasses[skinName] + '();' );
	if ( skinObjects[skinName] != null )
		skin = skinObjects[skinName];
	else
		debug ('could not use skin ' + skinName);
}


// =======================================
// GLOBAL VARIABLES
// =======================================

// All these variables are global and say something about the status of the cluster and the agent
// they should be used by the skins when sent a sync() message

//total speed in Hz of the entire cluster
var speed = 0;

//count of agent working, available,...
var agents = {
	workingAgentCount:0,
	availableAgentCount:0,
	unavailableAgentCount:0,
	offlineAgentCount:0,
	totalAgentCount:0,
	workingAgentPercentage:0,
	
	workingProcessorCount:0,
	availableProcessorCount:0,
	unavailableProcessorCount:0,
	offlineProcessorCount:0,
	onlineProcessorCount:0 //note the use of 'online', not 'total' --> need to fix xgridstatus tool
	//workingProcessorPercentage:0 //use same as agent, not defined --> need to fix xgridstatus tool
};

//status of the computer on which this widget is running
var status_off = 0;
var status_available = 1;
var status_working = 2;
var status_disconnected = 3;
var agent_status = status_off;

//this indicates wether or not the grid status is fresh (less than 5 min old)
var grid_status = status_off;

//value from the preferences
var display_pref = 'processor';



// =======================================
// CLUSTER STATUS
// =======================================

//xml http request
var req;
var xml_request_interval = 10000;
var time = 0;							// time of the day

//timer used to send requests to the xgrid status web server
var xml_request_timer = null;

// Download gauge.xml from stanford site.
function updatePlist(triggered) {
	//debug ( "updatePlist start");
	// concatenate random number to circumvent caching
	var url = "http://ires-genomics.ncl.ac.uk/xgrid/status.xml?" + Math.random();
	// use xmlhttprequest to download xml file
	req = new XMLHttpRequest();
	// call processReqChange when download has finished
	req.onreadystatechange = processReqChange;
	// get the file asynchronously
	req.open("GET", url, true);	
	// go!
	req.send(null);
	
	//debug ( "updatePlist end");
}


//variable use to remember what was the last date stored in the retrieved xml file
var previous_seconds=0;
var previous_minutes=0;
var noupdate_count=0;
var MAX_NOUPDATE_COUNT=3;

// The xml file is back --> get the new values
function processReqChange() {
	
	//debug ( "processReqChange start");
	
    //debug("req state  : " + req.readyState );
    //debug("req status : " + req.status );
    //debug("req status : " + req.statusText );
	
    // only if req shows "loaded"
    if ( req.readyState == 4 ) {

        // only if "OK"
        if (req.status == 200) {

			//extract values
			speed = parseInt(getElementTextNS("", "workingMegaHertz", req.responseXML, 0));
			var key;
			for ( key in agents ) {
				var value = parseFloat(getElementTextNS("", key, req.responseXML, 0));
				agents[key] = value;
			}
			
			//get the date at which the xml was created
			//var year = parseInt(getElementTextNS("", "Year", req.responseXML, 0));
			//var month = parseInt(getElementTextNS("", "MonthIndex", req.responseXML, 0)) - 1;
			//var day = parseInt(getElementTextNS("", "Day", req.responseXML, 0));
			//var hours = parseInt(getElementTextNS("", "Hours", req.responseXML, 0));
			var mins = parseInt(getElementTextNS("", "Minutes", req.responseXML, 0));
			var secs = parseInt(getElementTextNS("", "Seconds", req.responseXML, 0));
			if ( mins != previous_minutes || secs != previous_seconds ) {
				previous_minutes = mins;
				previous_seconds = secs;
				grid_status = status_working;
				noupdate_count = 0;
			} else if ( noupdate_count > MAX_NOUPDATE_COUNT )
				grid_status = status_off;
			else
				noupdate_count++;
			
			/*
			var xml_date = new Date (year,month,day,hours,mins,secs);
			var now_date = new Date ();
			var interval = ( now_date.getTime() - xml_date.getTime() ) / 60000; //in minutes
			if ( interval > 5 )
				grid_status = status_off;
			else
				grid_status = status_working;
			*/
			
			//reset the drawing
        	skin.sync();
        	skin.start();

		//else, there is a connection problem, 
		} else {
			if ( noupdate_count > MAX_NOUPDATE_COUNT )
				grid_status = status_off;
			else
				noupdate_count++;
			
			//if not in the widget, but e.g. developing in Safari
			//so let's put mock values for testing purposes
			if ( !window.widget) {
				debug ("using mock values for offline developement");
				if ( speed == 0 )
					speed = 643000;
				else
					speed *= 1 + ( Math.floor( Math.random() * 4 ) - 1) / 20;
				var key;
				for ( key in agents )
					agents[key]=Math.floor(Math.random()*800);
				//reset the drawing
				skin.sync();
				skin.start();
			}
		}
		
		
	}

	//debug ( "processReqChange end");
}

// used for xml parsing
// retrieve text of an XML document element, including
// elements using namespaces
function getElementTextNS(prefix, local, parentElem, index) {
    var result = "";
    result = parentElem.getElementsByTagName(local)[index];
    
    if (result) {
        // get text, accounting for possible
        // whitespace (carriage return) text nodes 
        if (result.childNodes.length > 1) {
            return result.childNodes[1].nodeValue;
        } else {
            return result.firstChild.nodeValue;    		
        }
    } else {
        return "n/a";
    }
}


// =======================================
// AGENT STATUS
// =======================================

/* agent status is checked using a perl script controlled from this javascript file*/

var should_check_agent_status = false;
var check_agent_status_interval = 5000;
var number_of_xgrid_process = -1;
var test_switch_light = 0;

function check_agent_status() {
	//debug ( "check_agent_status start" );
	if ( should_check_agent_status == false ) {
		should_check_agent_status = true;
		check_agent_status_private ();
	}
	//debug ( "check_agent_status end" );
}

var old_agent_status = -1;
function check_agent_status_private() {
	//debug ( "check_agent_status_private start" );

	if ( should_check_agent_status == false ) {
		//debug ("stop check agent status");
		return;
	}
	
	// get the new status
	// for use outside of Dashboard, switch every 2 update for testing purposes
	if ( ! window.widget ) {
		if ( test_switch_light > 2) {
			test_switch_light = 0;
			number_of_xgrid_process ++;
			if ( number_of_xgrid_process > 1 )
				number_of_xgrid_process = -1;
		} else
			test_switch_light++;
	} else {
		number_of_xgrid_process = widget.system("agentinfo.pl", null).outputString;
	}
	
	//var old_agent_status = agent_status;
	if ( number_of_xgrid_process == -1 )
		agent_status = status_off;
	else if ( number_of_xgrid_process == 0 )
		agent_status = status_available;
	else if ( number_of_xgrid_process > 0 )
		agent_status = status_working;

	
	//if the status changed, redraw everything
	if ( agent_status != old_agent_status ) {
		old_agent_status = agent_status;
		skin.sync();
		skin.start();
	}
	setTimeout('check_agent_status_private()', check_agent_status_interval);

	//debug ( "check_agent_status_private end" );
}



// =======================================
// WIDGET SETUP
// =======================================

//display preference for agent or processor count in the counter
//we use a variable that mirror the pref stored by Dashboard, because when testing in Safari, we can't use the user prefs and only the variable
display_pref = 'processor';

//skin preference
display_pref_skin = 'classic';

//the handlers for hiding and showing have to be defined in the body of the script
if (window.widget) {
	widget.onhide = onhide;
	widget.onshow = onshow;
}

//widget initialize
function oninit () {

	//debug ( "oninit start ");

	var display_popup;
	var display_popuptext;
	
	//read in display pref
	if (window.widget) {
		display_pref = widget.preferenceForKey('display_pref');
		display_pref_skin = widget.preferenceForKey('display_pref_skin');
	}

	//set up the skin preference
	display_popup = document.getElementById('prefStylePopup');
	display_popuptext = document.getElementById('prefStyleValue');
	if ( !skinPopupDisplay[display_pref_skin] )
		display_pref_skin = 'classic';
	display_popuptext.innerHTML=skinPopupDisplay[display_pref_skin];
	display_popup.options[skinPopupIndex[display_pref_skin]].selected = true;
		
	//set up the 'show' preference: agent or processor
	display_popup = document.getElementById('prefShowPopup');
	display_popuptext = document.getElementById('prefShowValue');
	if (display_pref && display_pref.length > 0){ 
		if(display_pref == 'agent'){
			display_popuptext.innerHTML='Agents';
			display_popup.options[0].selected = true;
		}else{
			display_popuptext.innerHTML='Processors';
			display_popup.options[1].selected = true;
		}
	} else {
		display_pref = 'processor';
		display_popuptext.innerHTML='Processors';
		display_popup.options[1].selected = true;
		if (window.widget)
			widget.setPreferenceForKey(display_pref, 'display_pref');
	}
	
	//set the initial skin
	setSkin(display_pref_skin);

	//start skin
	onshow();

	//debug ( "oninit end" );
}

// if widget is shown, restart timer
function onshow () {
	//debug ( "onshow start" );
	//start xml requests
	updatePlist(true);
	if (xml_request_timer == null)
		xml_request_timer = setInterval("updatePlist(true);", xml_request_interval);

	//start checking agent status
	check_agent_status();

	//start animations
	skin.sync();
	skin.start();
	
	//debug ( "onshow end" );

}



// if widget is hidden, stop timer and updating
function onhide () {
	//stop xml requests
	if (xml_request_timer != null) {
		clearInterval(xml_request_timer);
	}
	xml_request_timer = null;
	
	//stop agent status checking
	should_check_agent_status = false;

	//stop animations
	skin.stop();
}


// =======================================
// MOUSE METHODS
// =======================================

// click is forwarded to the skin
function mouseUp (event, tag)
{
	//debug ( "mouseUp" );
	if(	tag  == "canvas")
		skin.click();

}	


// =================================
// WIDGET BACK
// =================================

function showPrefs()
{
	var front = document.getElementById("front");
	var back = document.getElementById("back");
	
	if (window.widget)
		widget.prepareForTransition("ToBack");		
	
	onhide();
	front.style.display="none";		// verberg de voorkant
	back.style.display="block";		// toon de achterkant
	
	if (window.widget)
		setTimeout ('widget.performTransition();', 0);	

	// cleanup
	document.getElementById('fliprollie').style.display = 'none';  

}


function hidePrefs()
{
	//start everything again
	//we could have used onshow() but this seems to work around a redraw glitch that we have a hard time to control
	//it does not even work the same on different computers, something about the timing...
	//see also the end of the function
	setTimeout('onshow()',0.2);

	var front = document.getElementById("front");
	var back = document.getElementById("back");
	
	if (window.widget)
		widget.prepareForTransition("ToFront");		
	
	back.style.display="none";		// verberg de achterkant
	front.style.display="block";	// toon de voorkant

	if (window.widget)
		setTimeout ('widget.performTransition();', 0);		

	// cleanup (previously used for the non-standard back button)
	//document.getElementById('flipbackrollie').style.display = 'none';

	// draw again
	//we could have used onshow() but this seems to work around a redraw glitch that we have a hard time to control
	//it does not even work the same on different computers, something about the timing...
	window.setTimeout('skin.sync();',0);
	window.setTimeout('skin.start();',0);

}

function changePrefStyle(sender)
{
	var display_popup = document.getElementById('prefStylePopup');
	var display_popuptext = document.getElementById('prefStyleValue');
	display_pref_skin = display_popup.value;
	//debug(display_pref_skin);

	display_popuptext.innerHTML=skinPopupDisplay[display_pref_skin];
	display_popup.options[skinPopupIndex[display_pref_skin]].selected = true;
	
	if (window.widget)
		widget.setPreferenceForKey(display_pref_skin, 'display_pref_skin');

	//set the new skin
	setSkin(display_pref_skin);

}

function changePrefShow(sender)
{
	var display_popup = document.getElementById('prefShowPopup');
	var display_popuptext = document.getElementById('prefShowValue');
	display_pref = display_popup.value;
	//debug(display_pref);

	if(display_pref == 'agent')
		display_popuptext.innerHTML='Agents';
	else
		display_popuptext.innerHTML='Processors';
	
	if (window.widget)
		widget.setPreferenceForKey(display_pref, 'display_pref');

	//old code
	//   revert to front
	//	it seems this has to be done in the next event loop of the run loop
	//	otherwise we get a weird display bug
	//setTimeout('hidePrefs()', 0);

}


// =================================
// PREF BUTTON ANIMATION
// =================================

// white infobutton i animation  (fade in/out)
// under the motto "eat your own dogfood" we will use our own
// spring class for the fade in/out

// animation is currently disabled because of a bug in the
// mouse events handlers which make the widgets eat CPU usage
// like crazy: http://lists.apple.com/archives/dashboard-dev/2005/Aug/msg00099.html
// by commenting out the mousemove and -exit events in the html file
// and the opacity=0.0 in the css file, the i is always visible

var spring_fade  = fast_spring();
var is_fading = false;
var flipShown = false;
var fade_framerate = 10;

function fadeToNewValues(direction) {

	if ( is_fading == false )
		return;

	//move the springs for the needle and the counter
    spring_fade.move(1/fade_framerate);
 
	//now draw the new values and come back later if necessary
	drawFlip(direction);
	if ( spring_fade.is_moving)
		setTimeout('fadeToNewValues()', 1000/fade_framerate);
	else
		is_fading = false;
				
}

function fade (direction) {
	if ( is_fading == false ) {
		is_fading = true;
		fadeToNewValues(direction);
	}
}

function drawFlip(direction) {
	var opacity = 0.0;
	opacity = spring_fade.position;
	//debug(opacity);
	document.getElementById ('flip').style.opacity = opacity;
}

// =================================
// PREF BUTTON MOUSE EVENTS
// =================================

// mouse events invoked by the body, currently disabled

function mousemove (event)
{
	if (!flipShown)			
	{
		spring_fade.setTarget(1.0);
		fade('in');
		flipShown = true;							
	}
}

function mouseexit (event)
{
	if (flipShown)
	{
		spring_fade.setTarget(0.0);
		fade('out');
		flipShown = false;
	}
}

// these functions make the circle appear behind the i (rollover)

function enterflip(event)
{
	document.getElementById('fliprollie').style.display = 'block';
}

function exitflip(event)
{
	document.getElementById('fliprollie').style.display = 'none';
}



/* old code to handle the circle behind the non-standard back button (was used instead of the standard 'Done' button) */

// these functions make the circle appear behind the backbutton (rollover)

function enterbackflip(event)
{
	document.getElementById('flipbackrollie').style.display = 'block';
}

function exitbackflip(event)
{
	document.getElementById('flipbackrollie').style.display = 'none';
}

