//  Alexander Griekspoor (mek@mekentosj.com)
//  Charles Parnot (charles.parnot@stanford.edu)
//  mekentosj.com - Sat Jan 08 2005


// =======================================
// SKIN3 =  'CLASSIC' NON-OPTIMIZED
// =======================================


//Skin3 object constructor
//Same as Skin2 with no drawing optimization
//Used as a starting point for the 'glowing' skin

function Skin3()
{

//debug ("creating an instance of Skin3");

// =======================================
// GENERAL SETUP
// =======================================

//only one animation object
this.animation = new Animation ( reset_animation, move_animation, draw_animation, 30 );

//the animation use springs to model tachometer and counter behavior
var tachometer = slow_spring();
var counter = shaky_spring();

//the status light makes use of two objects
// - pulse  = infinite movement, no damping = pulsing light
// - spring = for transition = go from one color to another
var light = new Pulse ( 0.1, 60, 80 );
light.transition = slow_spring();
light.status = 0;
light.transition_initial = 0;
light.transition_final = 0;

//methods that all skins should respond to
this.sync = sync;
this.start = start;
this.stop = stop;
this.click = click;

//for debugging
this.animation.name="skin3_animation";


// =======================================
// DRAWING PARAMETERS
// =======================================

//the following variables could have been properties of the skin instead, but that was just easier this way
//whatever... the usage is the same in the end, as everything is inside the constructor and methods are in fact closures

//dimensions for the light
var light_w = 12;
var light_h = 12;
var light_x = 156;
var light_y = 85;

//dimensions for the counter legend
var legend_w = 41;
var legend_h = 10;
var legend_x = 113;
var legend_y = 85;


//this array will be used to automatically create image objects and declare variables for them (see below)
var images = {
	base:{   path:'skin2/base.png', x:0 , y:0 , w:200 , h:200 },
	glow:{  path:'skin1/glow.png', x:10 , y:10 , w:180 , h:100 },

	basecut:{   path:'skin2/base-cut.png', x:0 , y:0 , w:200 , h:200 },
	needle:{   path:'skin1/needle.png', x:0 , y:0 , w:8 , h:70 },

	mhz:{  path:'skin1/mhz.png',  x:78 , y:122 , w:45 , h:20 },
	ghz:{  path:'skin1/ghz.png',  x:78 , y:122 , w:45 , h:20 },
	thz:{  path:'skin1/thz.png',  x:78 , y:122 , w:45 , h:20 },
	x10:{  path:'skin1/x10.png',  x:82 , y:142 , w:35 , h:15 },
	x100:{ path:'skin1/x100.png', x:82 , y:142 , w:35 , h:15 },
	x1000:{ path:'skin1/x1000.png', x:82 , y:142 , w:35 , h:15 },
	
	counter_base:{  path:'skin2/counter_base.png', x:113 , y:96 , w:42 , h:14 },
	counter_mask:{  path:'skin1/counter_mask.png', x:113 , y:96 , w:42 , h:14 },
	decimals:{   path:'skin1/decimals.png', x:0 , y:0 , w:8 , h:150 },
	numbers:{   path:'skin1/numbers.png', x:0 , y:0 , w:8 , h:150 },
	
	working:{  path:'skin2/working.png',         x:legend_x , y:legend_y , w:legend_w , h:legend_h },
	available:{  path:'skin2/available.png',     x:legend_x , y:legend_y , w:legend_w , h:legend_h },
	unavailable:{  path:'skin2/unavailable.png', x:legend_x , y:legend_y , w:legend_w , h:legend_h },
	total:{  path:'skin2/total.png',             x:legend_x , y:legend_y , w:legend_w , h:legend_h },
	offline:{  path:'skin2/offline.png',         x:legend_x , y:legend_y , w:legend_w , h:legend_h },
	percentage:{  path:'skin2/percentage.png',   x:legend_x , y:legend_y , w:legend_w , h:legend_h },

	light_bevel:{   path:'skin1/light-bevel.png', x:light_x , y:light_y , w:light_w , h:light_h },
	light_black:{   path:'skin1/light-black.png', x:light_x , y:light_y , w:light_w , h:light_h },
	light_orange:{   path:'skin1/light-orange.png', x:light_x , y:light_y , w:light_w , h:light_h },
	light_green:{   path:'skin1/light-green.png', x:light_x , y:light_y , w:light_w , h:light_h },
	light_red:{   path:'skin1/light-red.png', x:light_x , y:light_y , w:light_w , h:light_h }
};
	
//load the images for skin 1 by creating images and declaring variables
for ( name in images ) {
	//debug ("creating ");
	var one_image = new Image (images[name].w,images[name].h);
	one_image.src = images[name].path;
	images[name].image = one_image;
	//create variable with the name of the image, so that we can refer to images using simple variable names
	eval ( 'var ' + name + ' = images[name]; ' );
}

//legend index to use for the counter
var legend_index = 0;
var legend_images = [ working,available, unavailable,offline,total,percentage];


//used to pick the right image for the light, depending on the status
var status_images = [ light_red,light_orange,light_green, light_red];


// =======================================
// SKIN METHODS (SEE PROTOCOL IN MAIN JS)
// =======================================

//keys to use to retrieve the number to be displayed in the counter
var keys = {
	agent: [
		'workingAgentCount',
		'availableAgentCount',
		'unavailableAgentCount',
		'offlineAgentCount',
		'totalAgentCount',
		'workingAgentPercentage'
	],
	processor: [
		'workingProcessorCount',
		'availableProcessorCount',
		'unavailableProcessorCount',
		'offlineProcessorCount',
		'onlineProcessorCount',
		'workingAgentPercentage'
	]
};

//depending on the type of info displayed, the counter may use a decimal or not
var decimals_flag = [false,false,false,false,false,true];


//this is called by the main script when the values to be displayed have been changed
function sync ()
{

	//reset values for the counter
	var new_target = agents[keys[display_pref][legend_index]];
	if ( ( new_target == undefined ) || isNaN(new_target) )
		new_target = 0;
	counter.setTarget(new_target);
	counter.decimal = decimals_flag[legend_index];
	
	//reset tachometer
	tachometer.setTarget(speed);
	
	//reset status light
	start_light_transition();
	
};


//start skin animation
function start ()
{
	this.animation.start();
}

//stop skin animation
function stop ()
{
	this.animation.stop();
}

//clicking should change:
//  - the legend for the counter
//  - the value displayed by the counter
function click ()
{
	legend_index ++;
	if (legend_index>5)
		legend_index = 0;
	
	//update the drawing
	this.sync();
	this.start();
}



// =======================================
// ANIMATION METHODS
// =======================================

//not used
function reset_animation ()
{
	return;
}

//will initiate a transition in the light status if an update is necessary
function start_light_transition ()
{
	//only start a transition if the previous is done and there is a transition to do
	if ( light.transition.is_moving == false  && light.status != agent_status ) {
		//debug ( "starting transition from " + this.status + " to " + agent_status);
		light.transition_initial = light.status;
		light.transition_final = agent_status;
		light.transition = slow_spring();
		light.transition.setTarget(1.0);
		light.transition.is_moving = true;
		light.status = agent_status;
		//adjust pulse frequency
		if ( agent_status == status_working )
			light.setFrequency(0.4);
		else if ( agent_status == status_available )
			light.setFrequency(0.1);
	}
}


//moving the animation is about moving the different springs and pulses modeling the different animated objects
function move_animation ( dt )
{
	//moving the tachometer and counter springs
	tachometer.move(dt);
	counter.move(dt);
	
	//moving the light
	var light_needs_animation = true;
	if ( light.transition.is_moving ) {
		light.move(dt);
		light.transition.move(dt);
		if ( light.transition.is_moving == false ) {
			//debug ("end transition");
			light.status = light.transition_final;
			//maybe a new transition is necessary?
			start_light_transition();
		}
	} else {
		if ( (agent_status == status_off && light.status == status_off ) ||
				(agent_status == status_disconnected && light.status == status_disconnected) )
			light_needs_animation = false;
		else
			light.move(dt);
	}
	
	//stop only if no animation at all
	if ( tachometer.is_moving == false  && counter.is_moving == false  && light_needs_animation == false )
		this.stop();

}

//drawing the animation
//calls separate methods for the different objects to draw
function draw_animation ()
{
	// get canvas and context
	var canvas  = document.getElementById("canvas");	
	var context = canvas.getContext("2d");

	//draw the background image
	context.clearRect(base.x, base.y, base.w, base.h );
	context.drawImage (base.image, base.x, base.y, base.w, base.h );

	//determine the scale to be used
	// if current_speed > target_speed, then use a scale appropriate for current_speed
	// if current_speed < target_speed, then use a scale appropriate for target_speed except if the spring is slow enough
	var scale_index_current = scale_index ( tachometer.position );
	var scale_index_target = scale_index ( tachometer.target );
	var scale_index_now;
	if ( scale_index_current >= scale_index_target )
		scale_index_now = scale_index_current;
	else {
		scale_index_now = scale_index_target;
		if ( tachometer.w < 0.1 ) //oscillation of the spring takes more than 10 seconds?
			scale_index_now --;
	}

	//draw the scale legends
	draw_scale(scale_index_now);
	
	//draw the counter
	draw_counter();
	
	//draw the light
	draw_light();
	
	//draw the needle of the tachometer;
	var meterangle =  beginangle + ( deltaangle * (tachometer.position / speed_scales[scale_index_now].max ) );
	draw_needle(meterangle);

	//add the glow
	context.drawImage (glow.image, glow.x, glow.y, glow.w, glow.h );
}

// =======================================
// DRAWING THE TACHOMETER
// =======================================

//drawing the tachometer involves several elements:
// - the right numbers for the right scale
// - the right labeling for the unit (usually GHz, but MHz can still happen if only one machine; and TeraHz, well,...)
// - the needle


//for each scale used to display the speed, there is a separate set of images to be used
var speed_scales = [
	{ min:0, max:8, images:[ basecut,mhz ]},
	{ min:0, max:80, images:[ basecut,mhz,x10 ]},
	{ min:0, max:800, images:[ basecut,mhz,x100 ]},
	
	{ min:0, max:8000, images:[ basecut,ghz ]},
	{ min:0, max:80000, images:[ basecut,ghz,x10 ]},
	{ min:0, max:800000, images:[ basecut,ghz,x100 ]},
	{ min:0, max:8000000, images:[ basecut, ghz,x1000 ] },

	{ min:0, max:80000000, images:[ basecut, thz,x10 ] },
	{ min:0, max:800000000, images:[ basecut, thz,x100 ] },
];



//this function is used to return the index in the speed_scales that correspond to speed_value
function scale_index ( speed_value ) {
	var n = speed_scales.length;
	for ( i=0; i<n; i++ ) {
		var max = speed_scales[i].max;
		if ( speed_value < max )
			break;
	}
	return i;
}

function draw_scale ( scale_index)
{
	//debug ("draw_tacho start");
	// get canvas and context
	var canvas  = document.getElementById("canvas");	
	var context = canvas.getContext("2d");

	//draw the scale elements as stored in the speed_scales array
	var elements = speed_scales[scale_index].images;
	for ( i = 0; i < elements.length ; i++ )
		context.drawImage (elements[i].image, elements[i].x, elements[i].y, elements[i].w, elements[i].h );
	
}



//angles at which the needle of the tachometer should be drawn
var beginangle = 0.85; 						// angle for 0
var endangle = 5.45;						// angle for 8
var deltaangle = endangle - beginangle;		// dynamic range

function draw_needle ( angle )
{
	// get canvas and context
	var canvas  = document.getElementById("canvas");	
	var context = canvas.getContext("2d");
	
	//draw the needle
	context.save();
		context.translate (100,100);
		context.rotate (angle);
		if ( grid_status == status_off )
			context.globalAlpha = 0.5;
		context.drawImage (needle.image, -4, 7, needle.w, needle.h);
	context.restore();
}


// =======================================
// DRAWING THE COUNTER
// =======================================


//display of the counter
var begin_counter = 0;                          		// offset for 0
var end_counter = 136;                          		// offset for 9
var span_counter = end_counter - begin_counter;  		// dynamic range

function draw_counter ()
{
	//debug ("start draw_counter");

	// get canvas and context
	var canvas  = document.getElementById("canvas");	
	var context = canvas.getContext("2d");
	
	//draw the legend for the counter: 'Working', 'Available',...
	var legend = legend_images[legend_index];
	context.drawImage (legend.image, legend.x, legend.y, legend.w, legend.h);

	//digit offset in pixels
	//digit at index 0 = right
	var digits = [ -2, -2, -2, -2 ];

	//get the offset for the first digit, which is special in 2 ways:
	// - it can be a decimal
	// - its position is fractional in all cases
	var nr; //digit value to be displayed
	var c; //value to be displayed
	if ( counter.decimal )
		c = counter.position * 10;
	else
		c = counter.position;
	nr = c % 10;
	digits[0] = Math.round ( begin_counter + nr * (span_counter / 10.0) );
	
	
	//if the first digit is close to 10, then we need to start moving some of the other digits
	//(those adjacent and also above 9, see below)
	var should_add_fraction = false;
	var fraction_to_add;
	if ( nr > 9 ) {
		should_add_fraction = true;
		var a = nr - 9.0;
		//this is what will be added to digits about to change (use the square for smoother movement)
		fraction_to_add = a * a;
	}

	//now loop through the remaining digits to determine their position
	for ( i=1; i<4; i++ ) {
		c = Math.floor (c/10);
		var nr = c % 10;
		if ( nr < 0 )
			nr += 10;
		//add a fractional part if necessary
		if ( should_add_fraction == true ) {
			nr += fraction_to_add;
			//debug ( "add to digit " + i + "fraction " + fraction_to_add + " = " + nr );
			//should we keep adding fraction?
			if ( nr < 9 )
				should_add_fraction = false;
		}
		digits[i] = Math.round ( begin_counter + nr * (span_counter / 10.0) );
	}
	
	//the drawing itself
	var imax = 4;
	digx = counter_mask.x + counter_mask.w - 10;
	digy = counter_mask.y + 2;

	//draw the digits
	if ( counter.decimal )
		context.drawImageFromRect(decimals.image, 0, digits[0], 8, 12, digx, digy, 8, 12,"source-over");
	else
		context.drawImageFromRect(numbers.image,  0, digits[0], 8, 12, digx, digy, 8, 12,"source-over");
	for ( i=1; i<imax;i++ )
		context.drawImageFromRect(numbers.image,  0, digits[i], 8, 12, digx-i*10, digy, 8, 12,"source-over");

	//draw the mask
	context.drawImageFromRect(counter_mask.image,  0, 0, 10*imax, counter_mask.h, digx-imax*10+10, counter_mask.y, 10*imax, counter_mask.h,"source-over");
	
}


// =======================================
// DRAWING THE STATUS LIGHT
// =======================================


function draw_light_with_status ( base_alpha, status )
{
	var img = status_images[status];
	//debug(base_alpha);
	//debug(status);

	// get canvas and context
	var canvas  = document.getElementById("canvas");	
	var context = canvas.getContext("2d");
	
	//case of a pulsed light
	if ( status == status_working || status == status_available ) {
		var alpha = light.position  / 100.0;
		//if ( Math.abs(context.globalAlpha-0.5) < 0.1 )
		//	debug("alpha in  = "+ context.globalAlpha);
		context.save();
			context.globalAlpha = base_alpha * alpha;
			context.drawImage(img.image, img.x, img.y, img.w, img.h);
			img = light_black;
			context.globalAlpha = base_alpha * (1.0 - alpha);
			context.drawImage(img.image, img.x, img.y, img.w, img.h);
		context.restore();
		
	}

	//case of a still light
	else {
		context.save();
			context.globalAlpha = base_alpha;
			context.drawImage(img.image, img.x, img.y, img.w, img.h);
		context.restore();
	}
}

function draw_light ()
{
	// get canvas and context
	var canvas  = document.getElementById("canvas");	
	var context = canvas.getContext("2d");
	
	//clear the area with the bevel image
	var img = light_bevel;
	context.save();
		context.globalCompositeOperation = 'copy';
		context.drawImage(img.image, img.x, img.y, img.w, img.h);
	context.restore();
	
	//in case of a transition, we need to overlay 2 images
	if ( light.transition.is_moving ) {
		context.save();
			draw_light_with_status(1.0-light.transition.position, light.transition_initial);
			draw_light_with_status(light.transition.position, light.transition_final);
		context.restore();
	}
	
	//otherwise, just 1 image
	else
		draw_light_with_status(1.0,light.status);
	
	//debug ( "drawLight end" );

}


}
