//  Alexander Griekspoor (mek@mekentosj.com)
//  Charles Parnot (charles.parnot@stanford.edu)
//  mekentosj.com - Sat Jan 08 2005


// =======================================
// ANIMATION OBJECT
// =======================================

/*
USAGE:
	var my_animation = animation ( my reset_method, my_move_method, my_draw_method, framerate );
	my_animation.start();
	...
	...
	my_animation.stop();
	...
	...
	function my_reset_method ( )
	{
		//code to reset drawing before starting animation
	}
	function my_move_method ( dt )
	{
		//code to change position from time t to t+dt
	}
	function my_draw_method
	{
		//draw my object at current time
	}
*/

//for debug
var _count_animations_running = 0;

//returns a closure used to call move_private using setTimeout; I need a closure because setTimeout only use function and can't be used with an object method
function make_move_private_closure (animation_object)
{
	return ( function () { animation_object.move_private (); } );
}


//constructor
function Animation ( reset_method, move_method, draw_method, framerate )
{
	this.should_animate = false;
	//this.should_reset = true;
	this.framerate = framerate;
	
	//methods
	this.start = start_animation;
	this.stop = stop_animation;
	this.move_private = move_private;
	this.reset = reset_method;
	this.move = move_method;
	this.draw = draw_method;
	
	//get a ref for a function object
	//this function = a closure to call move_private from 'setTimeout' where 'this' can't be used
	//each instance of Animation gets a different closure
	this.move_private_closure = make_move_private_closure (this); 
}

//start_animation and stop_animation use the flag 'should_animate' 
function start_animation ( )
{
	//debug ("begin start_animation "+this.name);
	if ( this.should_animate == false ) {
		this.should_animate = true;
		//_count_animations_running++; debug ( _count_animations_running + " animations running after starting " + this.name);
		this.reset();
		this.draw();
		setTimeout(this.move_private_closure, 1000/this.framerate);
	}
	//debug ("end start_animation "+this.name);
}

function stop_animation ( )
{
	//if ( this.should_animate ) { _count_animations_running--; debug( _count_animations_running + " animations running after stopping " + this.name); }

	//this is enough to stop everything on the next call of the move_private method
	this.should_animate = false;
	//debug ("animation "+this.name+" was stopped");	
}


//move_animation checks the status of the animation and keeps the animation going as necessary
//the use of framerate is not particularly smart, as it does not take into account the actual time elapsed since last move
function move_private ( )
{
	//debug ("begin move_private "+this.name);
	if ( this.should_animate == false )
		return;
	//if ( this.should_reset == true ) {
	//	this.reset();
	//	this.should_reset = false;
	//}
	this.move(1/this.framerate);
	this.draw();
	setTimeout(this.move_private_closure, 1000/this.framerate);
	//debug ("end move_private "+this.name);
}
