#! /usr/bin/perl -w


# ps -U root -o %cpu,ni,command,pid -c | grep xgridagenthelper

#get a list of all processes
my $ps = `/bin/ps -ax -o pid=PID,ppid=PPID,command=COMMAND,%cpu=CPU -c`;
my @lines = split /\n/,$ps;
#print $ps;

#get header line to know the order of the keys (not guaranteed by `ps` apparently)
my $header= shift @lines;
$header =~ s/^\s+//g;
my @keys = split /\s+/, $header;
my %indexes;
foreach (0..3) { $index{$keys[$_]}=$_ }
my $index_pid = $index{"PID"};
my $index_ppid = $index{"PPID"};
my $index_command = $index{"COMMAND"};
my $index_cpu = $index{"CPU"};

#parse the results to get the lists of pids and get the pid for xgridagenthelper
#pids are organized hierarchically in a hash, and we also keep the cpu values around
my %children;
my %cpu_usage;
my $xgah_pid;
foreach (@lines) {
	s/^\s+//g;
	my @values = split /\s+/;
	my $pid = $values[$index_pid];
	my $ppid = $values[$index_ppid];
	my $command = $values[$index_command];
	my $cpu = $values[$index_cpu];
	push @{$children{$ppid}}, $pid;
	$cpu_usage{$pid} = $cpu;
	if ( $command eq "xgridagenthelper" ) { $xgah_pid = $pid; }
}


#if no xgridagenthelper, that's it
unless ( $xgah_pid ) { print "-1"; exit 0 };

#get all the descendents of xgridagenthelper using a recursive sub
sub heirs
{
	my $parent = shift;
	my @children;
	if ( defined @{$children{$parent}} ) {
		@children = @{$children{$parent}};
	} else {
		@children = ();
	}
	my @result = @children;
	foreach ( @children ) {
		push @result, heirs ($_);
	}
	return @result;
}

#foreach (keys %children) {
#	print "children of $_: { ".join ( " ", @{$children{$_}} )."}\n\n";
#}



my @xgah_heirs = heirs($xgah_pid);
#print "heirs of $xgah_pid: { ".join ( " ", @xgah_heirs)."}\n\n";

#get total cpu usage
my $xg_cpu_usage = 0;
foreach ( @heirs ) {
	$xg_cpu_usage += $cpu_usage{$_};
}

print ( scalar @xgah_heirs );

#print "$xg_cpu_usage\n";
