/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.FastHashtable;
import flybase.FastProperties;
import flybase.FastStack;
import iubio.readseq.BioseqDoc;
import iubio.readseq.BioseqDocImpl;
import iubio.readseq.DocItem;
import iubio.readseq.FeatureItem;
import iubio.readseq.FeatureNote;
import iubio.readseq.XmlPrintWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class XmlDoc
extends BioseqDocImpl {
    public static String xmlprop = "XmlDoc";
    private static FastHashtable xlabel2keys = new FastHashtable();
    private static FastProperties keys2xlabel = new FastProperties();
    protected XmlPrintWriter xpr;
    protected int xindent;
    protected int lastlev = -1;
    protected FastStack endstack = new FastStack();
    protected String tagFeatureTable;
    protected String tagFeatureNote;
    protected String tagFeatureLocation;
    protected String tagFeatureValue;
    protected String tagFeatureItem;

    public XmlDoc() {
        this.initx();
    }

    public XmlDoc(BioseqDoc source) {
        super(source);
        this.fFromForeignFormat = !(source instanceof XmlDoc);
        this.initx();
    }

    public XmlDoc(String idname) {
        this.addBasicName(idname);
        this.initx();
    }

    public void setSourceDoc(BioseqDoc source) {
        super.setSourceDoc(source);
        this.fFromForeignFormat = !(source instanceof XmlDoc);
    }

    void initx() {
        this.tagFeatureTable = this.getFieldName(70);
        this.tagFeatureNote = this.getFieldName(72);
        this.tagFeatureLocation = this.getFieldName(75);
        this.tagFeatureValue = this.getFieldName(74);
        this.tagFeatureItem = this.getFieldName(71);
        this.kLinewidth = 80;
    }

    public void addDocLine(String line) {
        System.err.println("Use an XML parser instead of this XmlDoc.addDocLine()");
    }

    public String getBiodockey(String field) {
        return (String)xlabel2keys.get(field);
    }

    public String getFieldName(int kind) {
        return XmlDoc.getXMLFieldName(kind);
    }

    public static final String getXMLFieldName(int kind) {
        return XmlDoc.getXMLFieldName(new Integer(kind));
    }

    public static String getXMLFieldName(Integer kind) {
        if (kind == null) {
            return null;
        }
        String lab = null;
        String biodockey = BioseqDocImpl.getBiodockey(kind);
        if (biodockey != null) {
            lab = (String)keys2xlabel.get(biodockey);
        }
        if (lab == null && (lab = (String)BioseqDocImpl.biodockinds.get(kind)) == null) {
            lab = "Noname" + kind;
        }
        return lab;
    }

    public void startFeature(int kind, String field, String value) {
        if (kind == 71) {
            FeatureItem fi = new FeatureItem(field, value, 4);
            this.addFeature(fi);
        }
    }

    public void endFeature(int kind, String field, String value) {
        if (kind == 71) {
            if (field != null && field.length() > 0) {
                FeatureItem fi = new FeatureItem(field, value, 4);
                this.addFeature(fi);
            }
            this.curFieldItem = null;
        } else if (kind == 72) {
            if (this.curFieldItem == null) {
                System.err.println("Error: null feature item for note '" + field + "', val=" + value);
                return;
            }
            if (value != null && value.length() > 0) {
                int spc = value.indexOf(32);
                if (spc >= 0 && "/translation".equals(field)) {
                    String v = "";
                    int at0 = 0;
                    while (at0 >= 0) {
                        v = v + value.substring(at0, spc);
                        at0 = spc + 1;
                        if ((spc = value.indexOf(32, at0)) >= 0) continue;
                        v = v + value.substring(at0);
                        at0 = -1;
                    }
                    value = v;
                } else if (spc > 0 || !Character.isDigit(value.charAt(0))) {
                    value = "\"" + value + "\"";
                }
            }
            if (field != null && field.length() > 0 && field.charAt(0) == '/') {
                this.curFieldItem.putNote(new FeatureNote(field, value, 72, 5));
            } else if (value != null && value.length() > 0) {
                this.curFieldItem.appendNote(value);
            }
        }
    }

    public void addFeature(String field, String value, int level, boolean append) {
        field = this.uncleanXmlTag(field);
        if (level == 4) {
            if (append && this.curFieldItem != null) {
                this.curFieldItem.appendValue(value);
            } else {
                this.addFeature(new FeatureItem(field, value, 4));
            }
        } else if (this.curFieldItem != null) {
            if (!value.startsWith("/")) {
                this.curFieldItem.appendNote(value);
            } else {
                int spc;
                if (!(value == null || value.length() <= 0 || (spc = value.indexOf(32)) <= 0 && Character.isDigit(value.charAt(0)))) {
                    value = "\"" + value + "\"";
                }
                this.addFeatureNote(this.curFieldItem, value);
            }
        }
    }

    public void setIndent(int indent) {
        this.xindent = indent;
    }

    public void setOutput(Writer outs) {
        this.xpr = outs instanceof XmlPrintWriter ? (XmlPrintWriter)outs : new XmlPrintWriter(outs);
        this.pr = this.xpr;
        this.linesout = 0;
    }

    public void setOutput(OutputStream outs) {
        this.setOutput(new OutputStreamWriter(outs));
    }

    public int writeTo(Writer outs) {
        return this.writeTo(outs, false);
    }

    public int writeTo(Writer outs, boolean doId) {
        this.dontWriteId = !doId;
        this.setOutput(outs);
        this.writeAllText();
        this.popAllEndtags();
        this.pr.flush();
        return this.xpr.linesWritten();
    }

    protected void popAllEndtags() {
        this.popend(1);
        while (!this.endstack.empty()) {
            String endlab = (String)this.endstack.pop();
            this.xpr.writeEndElement(endlab, this.xindent);
        }
    }

    final void popend(int lev1) {
        if (this.lastlev == 2 && lev1 == 1) {
            --this.xindent;
        }
        if ((this.lastlev == 2 && lev1 != 2 || this.lastlev == 1 && lev1 != 2) && !this.endstack.empty()) {
            this.xpr.writeEndElement((String)this.endstack.pop(), this.xindent);
        }
        if (this.lastlev == 1 && lev1 == 2) {
            this.xpr.println();
            ++this.xindent;
        }
    }

    protected void writeDocItem(DocItem nv, boolean writeAll) {
        int lev1 = nv.getLevel();
        this.popend(lev1);
        this.lastlev = lev1;
        switch (nv.getKind()) {
            case 111: {
                return;
            }
            case 70: {
                if (!writeAll || this.featWrit || this.features().size() <= 0) break;
                this.xpr.writeStartElement(this.tagFeatureTable, this.xindent++);
                this.writeDocVector(this.features(), writeAll);
                this.writeExtractionFeature();
                this.popend(lev1);
                this.lastlev = lev1;
                this.xpr.writeEndElement(this.tagFeatureTable, --this.xindent);
                this.featWrit = true;
                break;
            }
            case 71: {
                if (!this.wantFeature(nv)) break;
                this.xpr.writeTagStart(this.tagFeatureItem, nv.getName(), this.xindent++);
                this.xpr.println();
                if (nv instanceof FeatureItem) {
                    FeatureItem fi = (FeatureItem)nv;
                    this.xpr.writeTag(this.tagFeatureLocation, nv.getValue(), this.xindent);
                    if (fi.notes != null) {
                        this.writeDocVector(fi.notes, false);
                    }
                } else if (nv.hasValue()) {
                    this.xpr.writeTag(this.tagFeatureValue, nv.getValue().trim(), this.xindent);
                }
                this.xpr.writeEndElement(this.tagFeatureItem, --this.xindent);
                break;
            }
            case 72: {
                this.xpr.writeTagStart(this.tagFeatureNote, nv.getName(), this.xindent++);
                if (nv.hasValue()) {
                    boolean noendeol;
                    int vlev = 0;
                    String val = nv.getValue().trim();
                    int lwidth = val.length() + this.tagFeatureValue.length() + 2 + this.xpr.atColumn();
                    if (lwidth > this.xpr.kLinewidth) {
                        this.xpr.println();
                        vlev = this.xindent;
                    }
                    boolean bl = noendeol = lwidth + this.tagFeatureValue.length() + 2 < this.xpr.kLinewidth;
                    if (noendeol) {
                        this.xpr.skipNextEndElementNewline();
                    }
                    this.xpr.writeTag(this.tagFeatureValue, val, vlev);
                }
                this.xpr.writeEndElement(this.tagFeatureNote, --this.xindent);
                break;
            }
            default: {
                String tag = this.getFieldLabel(lev1, nv);
                if (tag == null) break;
                String val = nv.getValue().trim();
                this.xpr.writeTagStart(tag, val, this.xindent);
                if (lev1 == 1) {
                    this.endstack.push(tag);
                    break;
                }
                this.xpr.writeEndElement(tag, this.xindent);
            }
        }
    }

    protected String cleanXmlTag(String tag) {
        if (Character.isDigit(tag.charAt(0))) {
            tag = "N" + tag;
        }
        char[] buf = tag.toCharArray();
        int i = 0;
        while (i < buf.length) {
            char c = buf[i];
            if (!Character.isLetterOrDigit(c) && c != '_' && c != '-' && c != '.' && c != ':') {
                buf[i] = 95;
            }
            ++i;
        }
        return new String(buf);
    }

    protected String uncleanXmlTag(String tag) {
        if (tag.startsWith("_")) {
            tag = "/" + tag.substring(1);
        } else if (tag.startsWith("N") && Character.isDigit(tag.charAt(1))) {
            tag = tag.substring(1);
        }
        return tag;
    }

    protected String getFieldLabel(int level, DocItem di) {
        String name = null;
        switch (level) {
            case 1: 
            case 2: 
            case 3: {
                name = this.fFromForeignFormat ? this.getFieldName(di.getKind()) : di.getName();
                if (name != null && name.length() != 0) break;
                return null;
            }
            default: {
                name = di.getName();
            }
        }
        name = this.cleanXmlTag(name);
        return name;
    }

    static {
        String pname = System.getProperty(xmlprop, xmlprop);
        BioseqDocImpl.getDocProperties(pname, keys2xlabel, xlabel2keys);
    }
}

