/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import iubio.readseq.Readseq;
import iubio.readseq.RsInputFile;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

class RsInputReader
extends RsInputFile {
    protected Reader fInsOrig;

    RsInputReader(Reader ins) throws IOException {
        this.fInsOrig = ins;
        this.openStream();
    }

    protected void openStream() throws IOException {
        this.in = this.fInsOrig;
        this.lock = this.in;
        this.makeRewindable();
    }

    public void reset() throws IOException {
        if (this.fInfile == null) {
            this.makeRewindable();
        } else {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.openFile();
        }
    }

    public void makeRewindable() {
        if (this.fInfile == null) {
            this.fInfile = Readseq.tempFile();
            try {
                int n;
                FileWriter fout = new FileWriter(this.fInfile);
                char[] buf = new char[8192];
                do {
                    if ((n = this.in.read(buf)) <= 0) continue;
                    fout.write(buf, 0, n);
                } while (n >= 0);
                fout.close();
                this.openFile();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
        if (this.fInfile != null) {
            this.fInfile.delete();
            this.fInfile = null;
        }
    }
}

