/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.Debug;
import iubio.readseq.BioseqReader;
import iubio.readseq.BioseqWriter;
import iubio.readseq.FileIndex;
import iubio.readseq.Readseq;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;

public abstract class InterleavedSeqWriter
extends BioseqWriter {
    protected File tempFile;
    protected FileIndex fileIndex;
    protected String saveLineEnd;
    protected boolean interleaved = true;
    protected boolean ifirst = true;
    protected int leafLines;
    protected int lastlen;
    protected String lenerr;

    public void finalize() throws Throwable {
        if (this.tempFile != null) {
            this.tempFile.delete();
            this.tempFile = null;
        }
        super.finalize();
    }

    public boolean interleaved() {
        return this.interleaved;
    }

    public void setinterleaved(boolean turnon) {
        this.interleaved = turnon;
    }

    public void writeRecordStart() {
        if (this.interleaved()) {
            this.fileIndex.indexit();
        }
        super.writeRecordStart();
    }

    public void writeRecordEnd() {
        this.ifirst = false;
        super.writeRecordEnd();
    }

    protected void writeln() {
        super.writeln();
        if (this.ifirst) {
            ++this.leafLines;
        }
    }

    public void writeHeader() throws IOException {
        super.writeHeader();
        this.ifirst = true;
        this.leafLines = 0;
        if (this.interleaved()) {
            try {
                this.tempFile = Readseq.tempFile();
                BufferedWriter tos = new BufferedWriter(new FileWriter(this.tempFile));
                this.fileIndex = new FileIndex(tos);
                this.douts = this.fileIndex;
                this.saveLineEnd = this.lineSeparator;
                this.lineSeparator = "\n";
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void writeTrailer() {
        if (this.lenerr != null) {
            BioseqReader.message("Warning: this format requires equal sequence lengths.");
            BioseqReader.message("       : lengths may be padded/truncated to first.");
            BioseqReader.message("       : first length " + this.lenerr);
        }
        if (this.interleaved()) {
            this.lineSeparator = this.saveLineEnd;
            this.fileIndex.indexEOF();
            try {
                this.douts.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.setOutput(this.outs);
            this.interleaveHeader();
            this.interleaveOutput();
        }
        super.writeTrailer();
    }

    protected int seqLen() {
        return this.lastlen > 0 ? this.lastlen : this.seqlen;
    }

    public boolean setSeq(Object seqob, int offset, int length, String seqname, Object seqdoc, int atseq, int basepart) {
        if (this.lastlen > 0 && length != this.lastlen) {
            if (this.lenerr == null) {
                this.lenerr = String.valueOf(this.lastlen) + " != ";
            }
            this.lenerr = this.lenerr + String.valueOf(length) + ", ";
            if (length > this.lastlen) {
                length = this.lastlen;
            }
        } else {
            this.lastlen = length;
        }
        return super.setSeq(seqob, offset, length, seqname, seqdoc, atseq, basepart);
    }

    protected void interleaveHeader() {
    }

    protected void interleaf(int leaf) {
    }

    protected void writePadLine(RandomAccessFile tempis, int iseq, long starti) {
    }

    protected void interleaveOutput() {
        int sn = this.fileIndex.indexCount();
        long[] sindex = this.fileIndex.indices();
        long[] atindex = this.fileIndex.newIndices();
        int nlines = this.linesout;
        Debug.println("n leaf linesout=" + this.linesout + ", leafLines=" + this.leafLines);
        try {
            RandomAccessFile tempis = new RandomAccessFile(this.tempFile, "r");
            for (int leaf = 0; leaf < nlines; ++leaf) {
                for (int iseq = 0; iseq < sn; ++iseq) {
                    long fini;
                    String line = "";
                    long starti = sindex[iseq];
                    long ati = atindex[iseq];
                    long endi = sindex[iseq + 1];
                    if (ati >= starti && ati <= endi) {
                        tempis.seek(ati);
                        line = tempis.readLine();
                    } else {
                        tempis.seek(starti);
                        for (int iline = 0; iline <= leaf; ++iline) {
                            line = tempis.readLine();
                        }
                    }
                    atindex[iseq] = fini = tempis.getFilePointer();
                    if (fini <= endi) {
                        if (line != null && line.length() > 0) {
                            this.writeString(line);
                        } else if (leaf < this.leafLines) {
                            this.writePadLine(tempis, iseq, starti);
                        }
                        this.writeln();
                        continue;
                    }
                    if (leaf >= this.leafLines) continue;
                    this.writePadLine(tempis, iseq, starti);
                    this.writeln();
                }
                this.interleaf(leaf);
            }
            tempis.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.tempFile.delete();
        this.tempFile = null;
    }
}

