/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

class HTMLFilterReader
extends FilterReader {
    final int kMaxbuf = 128;
    private char[] inbuf = new char[128];
    private int nbuf;
    private int atbuf;
    private int skipbytes;
    private boolean didskipbytes;

    public HTMLFilterReader(Reader in, int skipbytes) {
        super(in);
        this.skipbytes = skipbytes;
    }

    public void reset() throws IOException {
        this.in.reset();
        if (this.skipbytes > 0) {
            this.in.skip(this.skipbytes);
            this.didskipbytes = true;
        }
    }

    public boolean ready() throws IOException {
        if (this.didskipbytes) {
            return true;
        }
        return this.in.ready();
    }

    public int read() throws IOException {
        int c;
        this.didskipbytes = false;
        if (this.nbuf > 0) {
            if (this.atbuf < this.nbuf) {
                return this.inbuf[this.atbuf++];
            }
            this.nbuf = 0;
            this.atbuf = 0;
        }
        if ((c = this.in.read()) == 60) {
            while (c != 62) {
                c = this.in.read();
                if (c >= 0) continue;
                return c;
            }
            return this.read();
        }
        if (c == 38) {
            if (this.nbuf < 128) {
                this.inbuf[this.nbuf++] = (char)c;
            }
            while (c != 59 && this.nbuf < 128) {
                c = this.in.read();
                if (c < 0) {
                    return this.inbuf[this.atbuf++];
                }
                this.inbuf[this.nbuf++] = (char)c;
            }
            String s = new String(this.inbuf, this.atbuf, this.nbuf - this.atbuf);
            if ("&lt;".equals(s)) {
                this.nbuf = this.atbuf;
                return 60;
            }
            if ("&gt;".equals(s)) {
                this.nbuf = this.atbuf;
                return 62;
            }
            if ("&amp;".equals(s)) {
                this.nbuf = this.atbuf;
                return 38;
            }
            if ("&nbsp;".equals(s)) {
                this.nbuf = this.atbuf;
                return 32;
            }
            return this.inbuf[this.atbuf++];
        }
        return c;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int nread = 0;
        int i = 0;
        while (i < len) {
            int c = this.read();
            if (c < 0) {
                return i == 0 ? -1 : nread;
            }
            cbuf[off + i] = (char)c;
            ++nread;
            ++i;
        }
        return nread;
    }
}

