/*
 * Decompiled with CFR 0.152.
 */
package iubio.bioseq;

import iubio.bioseq.BaseKind;

public class Biobase {
    public byte c;
    public byte mask;
    public static final int kMaskEmpty = -1;

    public Biobase() {
        this.c = (byte)63;
    }

    public Biobase(byte base) {
        this.c = base;
    }

    public Biobase(char base) {
        this.c = (byte)base;
    }

    public Biobase(char base, boolean withmask) {
        if (withmask) {
            this.c = (byte)(base & 0xFF);
            this.mask = (byte)(base >> 8);
        } else {
            this.c = (byte)base;
        }
    }

    public Biobase(byte base, byte mask) {
        this.c = base;
        this.mask = mask;
    }

    public Biobase(char base, byte mask) {
        this.c = (byte)base;
        this.mask = mask;
    }

    public Biobase(Biobase bb) {
        this.c = bb.c;
        this.mask = bb.mask;
    }

    public byte base() {
        return this.c;
    }

    public byte mask() {
        return this.mask;
    }

    public char c() {
        return (char)this.c;
    }

    public char cmask() {
        return (char)this.mask;
    }

    public char basemask() {
        return (char)(this.c | this.mask << 8);
    }

    public byte maskAsText() {
        return (byte)((this.mask & 0x7F) + 63);
    }

    public final boolean isPrimenuc() {
        return BaseKind.isPrimenuc(this.c);
    }

    public final boolean isIUBsym() {
        return BaseKind.isIUBsym(this.c);
    }

    public final boolean isDnanuc() {
        return BaseKind.isDnanuc(this.c);
    }

    public final boolean isRnanuc() {
        return BaseKind.isRnanuc(this.c);
    }

    public final boolean isAmino() {
        return BaseKind.isAmino(this.c);
    }

    public final boolean isProtonly() {
        return BaseKind.isProtonly(this.c);
    }

    public final boolean isSeqsym() {
        return BaseKind.isSeqsym(this.c);
    }

    public final boolean isAlphaseq() {
        return BaseKind.isAlphaseq(this.c);
    }

    public final boolean isAlnumseq() {
        return BaseKind.isAlnumseq(this.c);
    }

    public final boolean isIndel() {
        return BaseKind.isIndel(this.c);
    }

    public final boolean isPrint() {
        return BaseKind.isPrint(this.c);
    }

    public final int isSeqChar() {
        return BaseKind.isSeqChar(this.c);
    }

    public final int isGCGSeqChar() {
        return BaseKind.isGCGSeqChar(this.c);
    }

    public final int isSeqNumChar() {
        return BaseKind.isSeqNumChar(this.c);
    }

    public final int isAnyChar() {
        return BaseKind.isAnyChar(this.c);
    }

    public final int maskBit(int masklevel) {
        return Biobase.maskBit(this.mask, masklevel);
    }

    public static int maskBit(byte maskbyte, int masklevel) {
        int b = maskbyte;
        switch (masklevel) {
            case 0: {
                b &= 0x7F;
                break;
            }
            case 1: {
                b &= 1;
                break;
            }
            case 2: {
                b &= 2;
                break;
            }
            case 3: {
                b &= 4;
                break;
            }
            case 4: {
                b &= 8;
                break;
            }
            case 5: {
                b &= 0x10;
                break;
            }
            case 6: {
                b &= 0x20;
                break;
            }
            case 7: {
                b &= 0x40;
                break;
            }
            default: {
                b = -1;
            }
        }
        return b;
    }

    public final boolean isMasked(int masklevel) {
        return this.maskBit(masklevel) > 0;
    }

    public static boolean isMasked(byte maskbyte, int masklevel) {
        int b = Biobase.maskBit(maskbyte, masklevel);
        return b > 0;
    }

    public final byte setMask(int masklevel, int maskval) {
        this.mask = Biobase.setMask(this.mask, masklevel, maskval);
        return this.mask;
    }

    public static byte setMask(byte b, int masklevel, int maskval) {
        switch (masklevel) {
            case 1: {
                if (maskval != 0) {
                    b = (byte)(b | 1);
                    break;
                }
                b = (byte)(b & 0xFFFFFFFE);
                break;
            }
            case 2: {
                if (maskval != 0) {
                    b = (byte)(b | 2);
                    break;
                }
                b = (byte)(b & 0xFFFFFFFD);
                break;
            }
            case 3: {
                if (maskval != 0) {
                    b = (byte)(b | 4);
                    break;
                }
                b = (byte)(b & 0xFFFFFFFB);
                break;
            }
            case 4: {
                if (maskval != 0) {
                    b = (byte)(b | 8);
                    break;
                }
                b = (byte)(b & 0xFFFFFFF7);
                break;
            }
            case 5: {
                if (maskval != 0) {
                    b = (byte)(b | 0x10);
                    break;
                }
                b = (byte)(b & 0xFFFFFFEF);
                break;
            }
            case 6: {
                if (maskval != 0) {
                    b = (byte)(b | 0x20);
                    break;
                }
                b = (byte)(b & 0xFFFFFFDF);
                break;
            }
            case 7: {
                if (maskval != 0) {
                    b = (byte)(b | 0x40);
                    break;
                }
                b = (byte)(b & 0xFFFFFFBF);
                break;
            }
        }
        return b;
    }

    public final byte flipMask(int masklevel) {
        this.mask = Biobase.flipMask(this.mask, masklevel);
        return this.mask;
    }

    public static byte flipMask(byte b, int masklevel) {
        switch (masklevel) {
            case 1: {
                b = (byte)(b ^ 1);
                break;
            }
            case 2: {
                b = (byte)(b ^ 2);
                break;
            }
            case 3: {
                b = (byte)(b ^ 4);
                break;
            }
            case 4: {
                b = (byte)(b ^ 8);
                break;
            }
            case 5: {
                b = (byte)(b ^ 0x10);
                break;
            }
            case 6: {
                b = (byte)(b ^ 0x20);
                break;
            }
            case 7: {
                b = (byte)(b ^ 0x40);
                break;
            }
        }
        return b;
    }
}

