/*
 * Decompiled with CFR 0.152.
 */
package flybase;

import flybase.FastVector;
import flybase.ObjectComparator;
import flybase.StringComparator;
import java.util.Enumeration;

public class SortedEnumeration {
    FastVector vec = new FastVector();
    ObjectComparator cmp;

    public SortedEnumeration(Enumeration en) {
        this(en, new StringComparator());
    }

    public SortedEnumeration(Enumeration en, ObjectComparator cmp) {
        while (en.hasMoreElements()) {
            this.vec.addElement(en.nextElement());
        }
        this.resort(cmp);
    }

    public FastVector vector() {
        return this.vec;
    }

    public Enumeration elements() {
        return this.vec.elements();
    }

    public void resort(ObjectComparator cmp) {
        this.cmp = cmp;
        this.quickr(0, this.vec.size() - 1);
    }

    protected final int compare(int a, int b) {
        return this.cmp.compareObjects(this.vec.elementAt(a), this.vec.elementAt(b));
    }

    protected final void swap(int a, int b) {
        Object aob = this.vec.elementAt(a);
        this.vec.setElementAt(this.vec.elementAt(b), a);
        this.vec.setElementAt(aob, b);
    }

    protected void quickr(int min, int max) {
        if (min < max) {
            int lo = min;
            int hi = max;
            while (true) {
                if (lo < hi && this.compare(lo, max) <= 0) {
                    ++lo;
                    continue;
                }
                while (hi > lo && this.compare(hi, max) >= 0) {
                    --hi;
                }
                if (lo < hi) {
                    this.swap(lo, hi);
                }
                if (lo >= hi) break;
            }
            this.swap(lo, max);
            if (lo - min < max - lo) {
                this.quickr(min, lo - 1);
                this.quickr(lo + 1, max);
            } else {
                this.quickr(lo + 1, max);
                this.quickr(min, lo - 1);
            }
        }
    }
}

