/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.StringTokenizer;

public class FetchFromSRS {
    public static final int v5 = 0;
    public static final int v4 = 1;
    public static int gSRSversion = 0;
    public static String gHost = "iubio.bio.indiana.edu";
    public static String gLibs = "genbank genbanknew gbest";
    public static String gField = "all";
    public static String gOptions = "-f des";
    public static String gQuery = "esterase*";
    public static String[] gPath = new String[]{"/srs5bin/cgi-bin/wgetz", "/srs/srsc"};
    String outname;
    String libs;

    public static void main(String[] args) {
        FetchFromSRS fsrs = new FetchFromSRS();
        try {
            fsrs.run(args);
        }
        catch (UsageException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void run(String[] args) throws Exception {
        this.readArgs(args);
        String url = "http://" + gHost + gPath[gSRSversion];
        PrintStream pr = System.out;
        if (this.outname != null) {
            try {
                pr = new PrintStream(new FileOutputStream(this.outname));
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        pr.println("<HTML><HEAD><BASE HREF=\"" + url + "\"></HEAD><BODY>");
        this.fetchFromUrl(pr, url + this.getQuery());
    }

    protected void readArgs(String[] args) throws Exception {
        if (args == null || args.length == 0) {
            this.usage();
        }
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            int at = arg.indexOf(61);
            String val = at > 0 ? arg.substring(at + 1) : null;
            if (arg.startsWith("out=")) {
                this.outname = val;
            } else if (arg.startsWith("host=")) {
                gHost = val;
            } else if (arg.startsWith("vers=")) {
                gSRSversion = val.indexOf(52) > 0 ? 1 : 0;
            } else if (arg.startsWith("field=")) {
                gField = val;
            } else if (arg.startsWith("lib=")) {
                this.libs = this.libs == null ? val : this.libs + " " + val;
            } else if (arg.startsWith("opts=")) {
                gOptions = val;
            } else if (val == null) {
                gQuery = arg;
            } else {
                this.usage();
            }
            ++i;
        }
    }

    public void usage() throws UsageException {
        System.out.println(this.getClass().getName() + " [arguments] query-term ");
        System.out.println("arguments:");
        System.out.println("  host=SRSserver[:port], default=" + gHost);
        System.out.println("  lib=data-library, default=" + gLibs);
        System.out.println("  field=data-field, default=" + gField);
        System.out.println("  opts=srs-options, default=" + gOptions);
        System.out.println("  vers=5 or 4 (srs server version)");
        System.out.println("  out=output.file");
        throw new UsageException();
    }

    protected void fetchFromUrl(PrintStream pr, String url) {
        try {
            DataInputStream din = new DataInputStream(new URL(url).openStream());
            String s = din.readLine();
            while (s != null) {
                pr.println(s);
                s = din.readLine();
            }
        }
        catch (Exception e) {
            System.err.println("fetch from '" + url + "' err: " + e.getMessage());
        }
    }

    protected String getQuery() {
        String q;
        if (gQuery.indexOf(93) > 0) {
            q = gQuery;
        } else {
            if (this.libs == null) {
                this.libs = gLibs;
            }
            q = "[" + this.encodeLibs(this.libs) + "-" + gField + ":" + gQuery + "]";
        }
        q = q + " " + gOptions;
        return "?" + URLEncoder.encode(q);
    }

    protected String encodeLibs(String libs) {
        String elibs = null;
        int nlib = 0;
        StringTokenizer st = new StringTokenizer(libs, " ");
        while (st.hasMoreTokens()) {
            ++nlib;
            elibs = elibs == null ? st.nextToken() : elibs + "_SP_" + st.nextToken();
        }
        if (nlib > 1) {
            elibs = "libs={" + elibs + "}";
        }
        return elibs;
    }
}

